/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.actions;

import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.DefaultHunterAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class LimitedHunterBatModeAction
extends DefaultHunterAction
implements ILastingAction<IHunterPlayer> {
    public static final float BAT_EYE_HEIGHT = 0.51000005f;
    public static final EntitySize BAT_SIZE = EntitySize.func_220311_c((float)0.8f, (float)0.6f);
    private static final float PLAYER_WIDTH = 0.6f;
    private static final float PLAYER_HEIGHT = 1.8f;
    private final UUID armorModifierUUID = UUID.fromString("4392fccb-4bfd-4290-b2e6-5cc91439053c");
    private final UUID armorToughnessModifierUUID = UUID.fromString("6d3df16d-85e4-4b99-b2fc-301818697a6d");

    public boolean activate(IHunterPlayer hunter, IAction.ActivationContext context) {
        PlayerEntity player = hunter.getRepresentingPlayer();
        this.setModifier(player, true);
        this.updatePlayer((HunterPlayer)hunter, true);
        return true;
    }

    public int getCooldown() {
        return (Integer)HunterAgeingConfig.limitedBatModeCooldown.get() * 20;
    }

    public int getDuration(int i) {
        return (Integer)HunterAgeingConfig.limitedBatModeDuration.get() * 20;
    }

    public int getDuration(IFactionPlayer player) {
        if (VampiricAgeingCapabilityManager.getAge((LivingEntity)player.getRepresentingPlayer()).map(ageCap -> ageCap.isTransformed()).orElse(false).booleanValue()) {
            return MathHelper.func_76125_a((int)((Integer)HunterAgeingConfig.limitedBatModeDurationTransformed.get()), (int)10, (int)0x6666665) * 20;
        }
        return (Integer)HunterAgeingConfig.limitedBatModeDuration.get() * 20;
    }

    public boolean isEnabled() {
        return (Boolean)HunterAgeingConfig.hunterLimitedBatModeAction.get();
    }

    public boolean canBeUsedBy(IHunterPlayer hunter) {
        return CapabilityHelper.getCumulativeTaintedAge(hunter.getRepresentingPlayer()) >= (Integer)HunterAgeingConfig.limitedBatModeAge.get() && !hunter.getRepresentingPlayer().func_70090_H() && hunter.getRepresentingPlayer().func_130014_f_().func_234923_W_() != World.field_234920_i_ && !this.shouldSunAffect(hunter.getRepresentingPlayer()) && !((List)VampirismConfig.SERVER.batDimensionBlacklist.get()).contains(hunter.getRepresentingPlayer().func_130014_f_().func_234923_W_().func_240901_a_().toString()) && hunter.getRepresentingEntity().func_184187_bx() == null;
    }

    public boolean shouldSunAffect(PlayerEntity player) {
        return Helper.gettingSundamge((LivingEntity)player, (IWorld)player.func_130014_f_(), (IProfiler)player.func_130014_f_().func_217381_Z()) && (Boolean)HunterAgeingConfig.sunAffectLimitedBatMode.get() != false;
    }

    public void onActivatedClient(IHunterPlayer hunter) {
        if (!VampiricAgeingCapabilityManager.getAge(hunter.getRepresentingEntity()).map(h -> h.getBatMode()).orElse(false).booleanValue()) {
            this.updatePlayer((HunterPlayer)hunter, true);
        }
    }

    public void onDeactivated(IHunterPlayer hunter) {
        PlayerEntity player = hunter.getRepresentingPlayer();
        this.setModifier(player, false);
        if (!player.func_233570_aj_()) {
            player.func_195064_c(new EffectInstance(Effects.field_76429_m, 20, 100, false, false));
        }
        this.updatePlayer((HunterPlayer)hunter, false);
    }

    public boolean onUpdate(IHunterPlayer hunter) {
        if (((List)VampirismConfig.SERVER.batDimensionBlacklist.get()).contains(hunter.getRepresentingPlayer().func_130014_f_().func_234923_W_().func_240901_a_().toString()) && hunter.getRepresentingPlayer().func_130014_f_().func_234923_W_() == World.field_234920_i_) {
            hunter.getRepresentingPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_dimension"), Util.field_240973_b_);
            return true;
        }
        if (this.shouldSunAffect(hunter.getRepresentingPlayer()) && !hunter.isRemote()) {
            hunter.getRepresentingPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_day"), Util.field_240973_b_);
            return true;
        }
        float exhaustion = ((Double)HunterAgeingConfig.limitedBatExhaustion.get()).floatValue();
        if (exhaustion > 0.0f) {
            hunter.getRepresentingPlayer().func_71024_bL().func_75113_a(exhaustion);
        }
        return hunter.getRepresentingPlayer().func_70090_H();
    }

    public void onReActivated(IHunterPlayer hunter) {
        this.setModifier(hunter.getRepresentingPlayer(), true);
        if (!VampiricAgeingCapabilityManager.getAge(hunter.getRepresentingEntity()).map(h -> h.getBatMode()).orElse(false).booleanValue()) {
            this.updatePlayer((HunterPlayer)hunter, true);
        }
    }

    private void setModifier(PlayerEntity player, boolean enabled) {
        if (enabled) {
            ModifiableAttributeInstance armorToughnessAttributeInst;
            ModifiableAttributeInstance armorAttributeInst = player.func_110148_a(Attributes.field_233826_i_);
            if (armorAttributeInst.func_111127_a(this.armorModifierUUID) == null) {
                armorAttributeInst.func_233769_c_(new AttributeModifier(this.armorModifierUUID, "Bat Armor Disabled", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if ((armorToughnessAttributeInst = player.func_110148_a(Attributes.field_233827_j_)).func_111127_a(this.armorToughnessModifierUUID) == null) {
                armorToughnessAttributeInst.func_233769_c_(new AttributeModifier(this.armorToughnessModifierUUID, "Bat Armor Disabled", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            player.field_71075_bZ.field_75101_c = true;
            player.field_71075_bZ.field_75100_b = true;
            this.setFlightSpeed(player, ((Double)VampirismConfig.BALANCE.vaBatFlightSpeed.get()).floatValue());
        } else {
            ModifiableAttributeInstance armorToughnessAttributeInst;
            AttributeModifier m2;
            ModifiableAttributeInstance armorAttributeInst = player.func_110148_a(Attributes.field_233826_i_);
            AttributeModifier m = armorAttributeInst.func_111127_a(this.armorModifierUUID);
            if (m != null) {
                armorAttributeInst.func_111124_b(m);
            }
            if ((m2 = (armorToughnessAttributeInst = player.func_110148_a(Attributes.field_233827_j_)).func_111127_a(this.armorToughnessModifierUUID)) != null) {
                armorToughnessAttributeInst.func_111124_b(m2);
            }
            boolean spectator = player.func_175149_v();
            boolean creative = player.func_184812_l_();
            player.field_71075_bZ.field_75101_c = spectator || creative;
            player.field_71075_bZ.field_75100_b = spectator;
            this.setFlightSpeed(player, 0.05f);
        }
        player.func_71016_p();
    }

    private void updatePlayer(HunterPlayer hunter, boolean bat) {
        PlayerEntity player = hunter.getRepresentingPlayer();
        VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(hntr -> hntr.setBatMode(bat));
        VampiricAgeingCapabilityManager.syncAgeCap(player);
        player.func_213323_x_();
        player.func_213301_b(Pose.CROUCHING);
        player.setForcedPose(bat ? null : Pose.STANDING);
        if (bat) {
            player.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_() + (double)(1.8f - LimitedHunterBatModeAction.BAT_SIZE.field_220316_b), player.func_226281_cx_());
        }
    }

    private void setFlightSpeed(PlayerEntity player, float speed) {
        player.field_71075_bZ.field_75096_f = speed;
    }

    public boolean showHudDuration(PlayerEntity player) {
        return true;
    }
}

