/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.capabilities;

import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.CommonConfig;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.werewolves.util.WReference;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.ModList;

public class CapabilityHelper {
    public static boolean isWerewolfCheckMod(Entity entity) {
        if (!ModList.get().isLoaded("werewolves")) {
            return false;
        }
        return de.teamlapen.werewolves.util.Helper.isWerewolf((Entity)entity);
    }

    public static boolean isWerewolfCheckMod(Entity entity, IPlayableFaction<?> faction) {
        if (!ModList.get().isLoaded("werewolves")) {
            return false;
        }
        return de.teamlapen.werewolves.util.Helper.isWerewolf((Entity)entity) || faction == WReference.WEREWOLF_FACTION;
    }

    public static int getCumulativeTaintedAge(PlayerEntity player) {
        if (!Helper.isHunter((PlayerEntity)player) || !((Boolean)HunterAgeingConfig.taintedBloodAvailable.get()).booleanValue()) {
            return 0;
        }
        boolean transformed = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.isTransformed()).orElse(false);
        int tainted = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getTemporaryTaintedAgeBonus()).orElse(0);
        int bonus = transformed ? 6 : tainted;
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
        if (age == 0 && !transformed) {
            return 0;
        }
        return age + bonus;
    }

    public static boolean shouldIncreaseRankHunted(PlayerEntity player) {
        if (Helper.isVampire((PlayerEntity)player)) {
            return VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(age -> age.getHunted() >= (Integer)((List)CommonConfig.huntedForNextAge.get()).get(age.getAge())).orElse(false);
        }
        return VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(age -> age.getHunted() >= (Integer)((List)HunterAgeingConfig.huntedForNextAge.get()).get(age.getAge())).orElse(false);
    }

    public static void increasePoints(ServerPlayerEntity player, int points) {
        VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(age -> {
            age.setHunted(age.getHunted() + points);
            VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)player);
            if (CapabilityHelper.shouldIncreaseRankHunted((PlayerEntity)player)) {
                VampiricAgeingCapabilityManager.increaseAge(player);
            }
        });
    }
}

