/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.capabilities;

import com.doctor.vampiricageing.actions.LimitedHunterBatModeAction;
import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import com.doctor.vampiricageing.data.EntityTypeTagProvider;
import com.doctor.vampiricageing.mixin.FoodStatsAccessor;
import com.google.common.collect.Multimap;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.MedChairBlock;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ThrowablePotionItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.profiler.IProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="vampiricageing")
public class HunterAgeingManager {
    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof ServerPlayerEntity && Helper.isHunter((Entity)event.getSource().func_76346_g()) && VampiricAgeingCapabilityManager.canAge((LivingEntity)event.getSource().func_76346_g())) {
            int pointWorth;
            if (event.getEntity().func_200600_R().func_220341_a(EntityTypeTagProvider.pettyHunt)) {
                pointWorth = (Integer)HunterAgeingConfig.pettyHuntWorth.get();
            } else if (event.getEntity().func_200600_R().func_220341_a(EntityTypeTagProvider.commonHunt)) {
                pointWorth = (Integer)HunterAgeingConfig.commonHuntWorth.get();
            } else if (event.getEntity().func_200600_R().func_220341_a(EntityTypeTagProvider.greaterHunt)) {
                pointWorth = (Integer)HunterAgeingConfig.greaterHuntWorth.get();
            } else {
                return;
            }
            CapabilityHelper.increasePoints((ServerPlayerEntity)event.getSource().func_76346_g(), pointWorth);
        }
        if (((Boolean)HunterAgeingConfig.permanentTransformationDeathReset.get()).booleanValue() && Helper.isHunter((Entity)event.getEntity()) && event.getEntity() instanceof ServerPlayerEntity) {
            VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getEntity()).ifPresent(hunter -> hunter.setTransformed(false));
        }
    }

    public static boolean isBat(PlayerEntity player) {
        return VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(age -> age.getBatMode()).orElse(false);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.func_82737_E() % 20L != 0L) {
            return;
        }
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = event.player;
        if (!Helper.isHunter((PlayerEntity)player) || !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
        if (age >= (Integer)HunterAgeingConfig.fasterRegenerationAge.get()) {
            Difficulty difficulty = player.field_70170_p.func_175659_aa();
            boolean flag = player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223606_i);
            FoodStats stats = player.func_71024_bL();
            if (flag && stats.func_75115_e() > 0.0f && player.func_70996_bM() && stats.func_75116_a() >= 20) {
                if (((FoodStatsAccessor)stats).getFoodTimer() >= 9) {
                    float f = Math.min(stats.func_75115_e(), 6.0f);
                    player.func_70691_i(f / 6.0f);
                    stats.func_75113_a(f);
                }
            } else if (flag && stats.func_75116_a() >= 18 && player.func_70996_bM()) {
                if (((FoodStatsAccessor)stats).getFoodTimer() >= 79) {
                    player.func_70691_i(1.0f);
                    stats.func_75113_a(6.0f);
                }
            } else if (stats.func_75116_a() <= 0 && ((FoodStatsAccessor)stats).getFoodTimer() >= 79 && (player.func_110143_aJ() > 10.0f || difficulty == Difficulty.HARD || player.func_110143_aJ() > 1.0f && difficulty == Difficulty.NORMAL)) {
                player.func_70097_a(DamageSource.field_76366_f, 1.0f);
            }
        }
        if (((Boolean)HunterAgeingConfig.taintedBloodAvailable.get()).booleanValue() && age >= (Integer)HunterAgeingConfig.taintedBloodBottleAge.get()) {
            VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(hunter -> {
                if (hunter.getTemporaryTaintedAgeBonus() > 0 || hunter.isTransformed()) {
                    if (!hunter.isTransformed()) {
                        hunter.setTemporaryTainedTicks(hunter.getTemporaryTainedTicks() - 20);
                        if (hunter.getTemporaryTainedTicks() <= 0) {
                            hunter.setTemporaryTaintedAgeBonus(0);
                        }
                    }
                    int cumulativeAge = CapabilityHelper.getCumulativeTaintedAge(player);
                    if (((Boolean)HunterAgeingConfig.sunAffectTainted.get()).booleanValue() && cumulativeAge >= (Integer)HunterAgeingConfig.taintedSunAffectAge.get()) {
                        int ticksInSun = hunter.getTicksInSun();
                        if (Helper.gettingSundamge((LivingEntity)player, (IWorld)player.func_130014_f_(), (IProfiler)player.func_130014_f_().func_217381_Z()) && ticksInSun <= (Integer)HunterAgeingConfig.maxTicksInSun.get()) {
                            hunter.setTicksInSun(ticksInSun + 20 * (Integer)((List)HunterAgeingConfig.taintedAgeSunBadnessMultiplier.get()).get(cumulativeAge));
                        } else if (hunter.getTicksInSun() >= 100) {
                            int reductionAmount = hunter.getTicksInSun() < 1000 ? 100 : 1000;
                            hunter.setTicksInSun(Math.max(0, ticksInSun - reductionAmount));
                        }
                        HunterAgeingManager.applySunEffects(player, hunter.getTicksInSun());
                    }
                    if (cumulativeAge >= (Integer)HunterAgeingConfig.underwaterBreathingTaintedAge.get()) {
                        player.func_70050_g(300);
                    }
                    VampiricAgeingCapabilityManager.syncAgeCap(player);
                }
            });
        }
    }

    public static void applySunEffects(PlayerEntity player, int ticksInSun) {
        if (player.field_71075_bZ.field_75098_d || player.func_70644_a((Effect)ModEffects.SUNSCREEN.get())) {
            return;
        }
        if (ticksInSun >= (Integer)HunterAgeingConfig.sunWeaknessTicks.get()) {
            player.func_195064_c(new EffectInstance(Effects.field_76437_t, 40, 0));
        }
        if (ticksInSun >= (Integer)HunterAgeingConfig.sunSlownessTicks.get() && ticksInSun < (Integer)HunterAgeingConfig.sunSlownessThreeTicks.get()) {
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 1));
        } else if (ticksInSun >= (Integer)HunterAgeingConfig.sunSlownessThreeTicks.get()) {
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 2));
        }
        if (ticksInSun >= (Integer)HunterAgeingConfig.sunDamageTicks.get()) {
            player.func_70097_a(VReference.SUNDAMAGE, 1.5f);
            if (ticksInSun >= (Integer)HunterAgeingConfig.sunDamageTicks.get() * 2) {
                player.func_70097_a(VReference.SUNDAMAGE, 1.5f);
            }
            if (ticksInSun >= (Integer)HunterAgeingConfig.sunDamageTicks.get() * 3) {
                player.func_70097_a(VReference.SUNDAMAGE, 2.0f);
            }
        }
        if (ticksInSun >= (Integer)HunterAgeingConfig.sunBlindnessTicks.get()) {
            player.func_195064_c(new EffectInstance(Effects.field_76440_q, 40, 0));
        }
    }

    @SubscribeEvent
    public static void onInteractBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (Helper.isHunter((PlayerEntity)player) && !player.func_130014_f_().field_72995_K && player.func_130014_f_().func_180495_p(event.getPos()).func_177230_c() instanceof MedChairBlock && VampiricAgeingCapabilityManager.canAge((LivingEntity)player)) {
            int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
            int huntedPoints = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getHunted()).orElse(0);
            int huntedForNextAge = (Integer)((List)HunterAgeingConfig.huntedForNextAge.get()).get(age) - huntedPoints;
            player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampiricageing.progress_hunted", new Object[]{huntedForNextAge}).func_240699_a_(TextFormatting.DARK_RED), Util.field_240973_b_);
        }
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent event) {
        PlayerEntity player = event.getPlayer();
        if (event.getItemStack().func_77973_b() == ModItems.INJECTION_GARLIC.get() && CapabilityHelper.getCumulativeTaintedAge(player) > 0) {
            VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(hunter -> {
                hunter.setTemporaryTaintedAgeBonus(0);
                hunter.setTemporaryTainedTicks(0);
                hunter.setTransformed(false);
            });
            VampiricAgeingCapabilityManager.syncAgeCap(player);
            event.getItemStack().func_190918_g(1);
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        if (event.getSource().func_76346_g() == null) {
            return;
        }
        Entity sourceEntity = event.getSource().func_76346_g();
        if (!(Helper.isHunter((Entity)sourceEntity) && ((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue() && sourceEntity instanceof PlayerEntity)) {
            return;
        }
        Item item = ((PlayerEntity)sourceEntity).func_184614_ca().func_77973_b();
        Multimap attributes = item.getAttributeModifiers(EquipmentSlotType.MAINHAND, ((PlayerEntity)sourceEntity).func_184614_ca());
        if (!attributes.get((Object)Attributes.field_233823_f_).isEmpty() && (Helper.isVampire((Entity)event.getEntity()) || CapabilityHelper.isWerewolfCheckMod(event.getEntity()))) {
            PlayerEntity hunterSource = (PlayerEntity)sourceEntity;
            int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)hunterSource).map(ageCap -> ageCap.getAge()).orElse(0);
            event.setAmount(event.getAmount() + ((Double)((List)HunterAgeingConfig.ageEnemyFactionDamageIncrease.get()).get(age)).floatValue());
        }
    }

    @SubscribeEvent
    public static void onXpGain(PlayerXpEvent.XpChange event) {
        PlayerEntity player = event.getPlayer();
        if (!Helper.isHunter((PlayerEntity)player) || !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
        event.setAmount(Math.round((float)event.getAmount() / ((Double)((List)HunterAgeingConfig.xpGainReduction.get()).get(age)).floatValue()));
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (!((Boolean)HunterAgeingConfig.hunterIncreasedMiningSpeed.get()).booleanValue() && !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        if (!Helper.isHunter((Entity)event.getEntity())) {
            return;
        }
        if (HunterAgeingManager.isBat(event.getPlayer())) {
            event.setCanceled(true);
        }
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getPlayer()).map(ageCap -> ageCap.getAge()).orElse(0);
        event.setNewSpeed(event.getOriginalSpeed() + ((Double)((List)HunterAgeingConfig.hunterMiningSpeedBonus.get()).get(age)).floatValue());
    }

    @SubscribeEvent
    public static void eyeHeight(EntityEvent.Size event) {
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && ((PlayerEntity)event.getEntity()).field_71071_by != null && event.getEntity().func_70089_S() && event.getEntity().func_213303_ch().func_189985_c() != 0.0 && event.getEntity().func_184187_bx() == null && VampiricAgeingCapabilityManager.getAge((LivingEntity)(player = (PlayerEntity)event.getEntity())).map(hunter -> hunter.getBatMode()).orElse(false).booleanValue()) {
            event.setNewSize(LimitedHunterBatModeAction.BAT_SIZE);
            event.setNewEyeHeight(0.51000005f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttackEntity(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_70089_S() && HunterAgeingManager.isBat(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTryMount(EntityMountEvent event) {
        if (event.getEntity() instanceof PlayerEntity && HunterAgeingManager.isBat((PlayerEntity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockRightClicked(PlayerInteractEvent.RightClickBlock event) {
        if (HunterAgeingManager.isBat(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemUse(LivingEntityUseItemEvent.Start event) {
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && HunterAgeingManager.isBat(player = (PlayerEntity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        if ((event.getItemStack().func_77973_b() instanceof ThrowablePotionItem || event.getItemStack().func_77973_b() instanceof CrossbowItem) && HunterAgeingManager.isBat(event.getPlayer())) {
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)event.getWorld().func_201670_d()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity) || !event.getEntity().func_70089_S()) {
            return;
        }
        if (event.getPlacedBlock().func_196958_f()) {
            return;
        }
        try {
            if (HunterAgeingManager.isBat((PlayerEntity)event.getEntity())) {
                MinecraftServer server;
                TileEntity te;
                event.setCanceled(true);
                if (event.getPlacedBlock().hasTileEntity() && (te = event.getWorld().func_175625_s(event.getPos())) instanceof IInventory) {
                    ((IInventory)te).func_174888_l();
                }
                if (event.getEntity() instanceof ServerPlayerEntity && (server = event.getEntity().field_70170_p.func_73046_m()) != null) {
                    server.func_184103_al().func_72385_f((ServerPlayerEntity)event.getEntity());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

