/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.capabilities;

import com.doctor.vampiricageing.actions.VampiricAgeingActions;
import com.doctor.vampiricageing.capabilities.AgeingCapability;
import com.doctor.vampiricageing.capabilities.AgeingCapabilityProvider;
import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.capabilities.IAgeingCapability;
import com.doctor.vampiricageing.config.CommonConfig;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import com.doctor.vampiricageing.config.WerewolvesAgeingConfig;
import com.doctor.vampiricageing.data.EntityTypeTagProvider;
import com.doctor.vampiricageing.networking.Networking;
import com.doctor.vampiricageing.networking.SyncCapabilityPacket;
import com.doctor.vampiricageing.skills.VampiricAgeingSkills;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.event.FactionEvent;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.items.BloodBottleItem;
import de.teamlapen.vampirism.particle.GenericParticleData;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.util.WReference;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="vampiricageing")
public class VampiricAgeingCapabilityManager {
    public static final ResourceLocation AGEING_KEY = new ResourceLocation("vampiricageing", "ageing");
    public static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("060749f1-7868-4fdf-8a54-eb5ddf93742e");
    public static final UUID BITE_DAMAGE_MULTIPLIER_UUID = UUID.fromString("7936e1c2-3439-4819-b0e3-ea57dcc3e8ba");
    public static final UUID MAX_HEALTH_UUID = UUID.fromString("08251d58-2513-4768-b4b5-f2a1a239998e");
    public static final UUID WEREWOLF_MAX_HEALTH_AGE_UUID = UUID.fromString("47461eb3-1376-460d-b542-5d4d17d84b86");
    public static final UUID AGE_ADVANCED_SPEED_INCREASE = UUID.fromString("5728457b-ce7e-4bb5-96de-d1c6809dd1c3");
    public static final UUID EXHAUSTION_UUID = UUID.fromString("1f14dd76-7d9b-47b3-9951-1c221f78d49f");
    public static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("94d546a9-6848-48cf-bcba-5e162987d58b");
    public static final UUID STRENGTH_INCREASE = UUID.fromString("ee0dca39-3d03-4f75-aed0-c1ae017969f2");
    public static final UUID WEREWOLF_STRENGTH_INCREASE = UUID.fromString("a47672d2-88c8-41de-bafe-8683de11f82a");
    public static final UUID HUNTER_MAX_HEALTH_UUID = UUID.fromString("c668f879-d57a-4182-ba82-87d93610e934");
    public static final UUID HUNTER_SPEED_INCREASE_UUID = UUID.fromString("4277f565-237e-4802-9653-203aa2ef92bb");
    public static final UUID HUNTER_TAINTED_DAMAGE_INCREASE_UUID = UUID.fromString("ea65e383-9172-42ab-a685-53a0c1c4fb3f");
    public static final UUID HUNTER_TAINTED_MAX_HEALTH_INCREASE_UUID = UUID.fromString("128f81c7-27b4-4d0b-a07f-e1a0055ba36a");
    public static final UUID HUNTER_TAINTED_MOVEMENT_SPEED_INCREASE_UUID = UUID.fromString("3c4cdc94-75e8-4528-9800-90298dc44b8a");
    @CapabilityInject(value=IAgeingCapability.class)
    public static final Capability<IAgeingCapability> AGEING_CAPABILITY = null;

    public static LazyOptional<IAgeingCapability> getAge(LivingEntity livingEntity) {
        if (livingEntity == null) {
            return LazyOptional.empty();
        }
        return livingEntity.getCapability(AGEING_CAPABILITY);
    }

    public static boolean canAge(LivingEntity entity) {
        if (entity instanceof ServerPlayerEntity && entity.func_70089_S()) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if (Helper.isVampire((PlayerEntity)player)) {
                int level = FactionPlayerHandler.getOpt((PlayerEntity)player).map(fph -> fph.getCurrentLevel(VReference.VAMPIRE_FACTION)).orElse(0);
                int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
                return level >= (Integer)CommonConfig.levelToBeginAgeMechanic.get() && age < 5;
            }
            if (CapabilityHelper.isWerewolfCheckMod((Entity)player) && ((Boolean)WerewolvesAgeingConfig.werewolfAgeing.get()).booleanValue()) {
                int level = FactionPlayerHandler.getOpt((PlayerEntity)player).map(fph -> fph.getCurrentLevel(WReference.WEREWOLF_FACTION)).orElse(0);
                int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
                return level >= (Integer)CommonConfig.levelToBeginAgeMechanic.get() && age < 5;
            }
            if (((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue() && Helper.isHunter((PlayerEntity)player)) {
                int level = FactionPlayerHandler.getOpt((PlayerEntity)player).map(fph -> fph.getCurrentLevel(VReference.HUNTER_FACTION)).orElse(0);
                int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
                return level >= (Integer)CommonConfig.levelToBeginAgeMechanic.get() && age < 5;
            }
        }
        return false;
    }

    public static boolean shouldIncreaseRankTicks(PlayerEntity player) {
        return VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(age -> age.getTime() >= (Integer)((List)CommonConfig.ticksForNextAge.get()).get(age.getAge())).orElse(false);
    }

    public static boolean shouldIncreaseRankInfected(PlayerEntity player) {
        return VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(age -> age.getInfected() >= (Integer)((List)CommonConfig.infectedForNextAge.get()).get(age.getAge())).orElse(false);
    }

    public static boolean shouldIncreaseRankDrained(PlayerEntity player) {
        return VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(age -> age.getDrained() >= (Integer)((List)CommonConfig.drainedBloodForNextAge.get()).get(age.getAge())).orElse(false);
    }

    public static void increaseAge(ServerPlayerEntity player) {
        if (VampiricAgeingCapabilityManager.canAge((LivingEntity)player)) {
            VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(age -> {
                if (Helper.isVampire((PlayerEntity)player)) {
                    player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)ModSounds.ENTITY_VAMPIRE_SCREAM.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_194228_if, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                ModParticles.spawnParticlesServer((World)player.field_70170_p, (IParticleData)new GenericParticleData((ParticleType)ModParticles.GENERIC.get(), new ResourceLocation("minecraft", "spell_1"), 50, 0x8B0000, 0.2f), (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (int)100, (double)1.0, (double)1.0, (double)1.0, (double)0.0);
                age.setAge(age.getAge() + 1);
                if (Helper.isHunter((PlayerEntity)player) && player.func_70644_a((Effect)com.doctor.vampiricageing.init.ModEffects.TAINTED_BLOOD_EFFECT.get())) {
                    player.func_195063_d((Effect)com.doctor.vampiricageing.init.ModEffects.TAINTED_BLOOD_EFFECT.get());
                }
                VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)player);
            });
        }
    }

    public static void changeUpStep(PlayerEntity player, IPlayableFaction<?> faction) {
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
        if (Helper.isVampire((PlayerEntity)player) || faction == VReference.VAMPIRE_FACTION) {
            if (age == 0 || age < (Integer)CommonConfig.stepAssistBonus.get()) {
                player.field_70138_W = 0.6f;
                VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(ageCap -> ageCap.setUpStep(0.6f));
            }
            if (age > 0 && age >= (Integer)CommonConfig.stepAssistBonus.get()) {
                player.field_70138_W = 1.0f;
                VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(ageCap -> ageCap.setUpStep(1.0f));
            }
        }
        if (Helper.isHunter((PlayerEntity)player) || faction == VReference.HUNTER_FACTION) {
            if (age == 0 || age < (Integer)HunterAgeingConfig.stepAssistAge.get()) {
                player.field_70138_W = 0.6f;
                VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(ageCap -> ageCap.setUpStep(0.6f));
            }
            if (age > 0 && age >= (Integer)HunterAgeingConfig.stepAssistAge.get()) {
                player.field_70138_W = 1.0f;
                VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(ageCap -> ageCap.setUpStep(1.0f));
            }
        }
        VampiricAgeingCapabilityManager.syncAgeCapNoChange(player);
    }

    public static void onAgeChange(ServerPlayerEntity player, IPlayableFaction<?> faction) {
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
        VampiricAgeingCapabilityManager.checkSkills(age, player);
        VampiricAgeingCapabilityManager.changeUpStep((PlayerEntity)player, faction);
        if (Helper.isVampire((PlayerEntity)player) || faction == VReference.VAMPIRE_FACTION) {
            VampiricAgeingCapabilityManager.removeModifier(player.func_110148_a((Attribute)de.teamlapen.vampirism.core.ModAttributes.BLOOD_EXHAUSTION.get()), EXHAUSTION_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.func_110148_a(Attributes.field_233818_a_), MAX_HEALTH_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.func_110148_a(Attributes.field_233823_f_), STRENGTH_INCREASE);
            if (((Boolean)CommonConfig.shouldAgeAffectExhaustion.get()).booleanValue()) {
                player.func_110148_a((Attribute)de.teamlapen.vampirism.core.ModAttributes.BLOOD_EXHAUSTION.get()).func_233769_c_(new AttributeModifier(EXHAUSTION_UUID, "AGE_EXHAUSTION_CHANGE", ((Double)((List)CommonConfig.ageExhaustionEffect.get()).get(age)).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            player.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier(STRENGTH_INCREASE, "AGE_ATTACK_DAMAGE_INCREASE", ((Double)((List)CommonConfig.ageDamageIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier(MAX_HEALTH_UUID, "MAX_HEALTH_AGE_CHANGE", ((Double)((List)CommonConfig.maxHealthIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        if (CapabilityHelper.isWerewolfCheckMod((Entity)player, faction)) {
            VampiricAgeingCapabilityManager.removeModifier(player.func_110148_a((Attribute)ModAttributes.BITE_DAMAGE.get()), BITE_DAMAGE_MULTIPLIER_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.func_110148_a(Attributes.field_233823_f_), WEREWOLF_STRENGTH_INCREASE);
            VampiricAgeingCapabilityManager.removeModifier(player.func_110148_a(Attributes.field_233818_a_), WEREWOLF_MAX_HEALTH_AGE_UUID);
            player.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier(WEREWOLF_STRENGTH_INCREASE, "WEREWOLF_AGE_ATTACK_DAMAGE_INCREASE", ((Double)((List)WerewolvesAgeingConfig.ageDamageIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier(WEREWOLF_MAX_HEALTH_AGE_UUID, "WEREWOLF_MAX_HEALTH_AGE_CHANGE", ((Double)((List)WerewolvesAgeingConfig.maxHealthIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.func_110148_a((Attribute)ModAttributes.BITE_DAMAGE.get()).func_233769_c_(new AttributeModifier(BITE_DAMAGE_MULTIPLIER_UUID, "AGE_BITE_DAMAGE_INCREASE", ((Double)((List)WerewolvesAgeingConfig.biteDamageMultiplier.get()).get(age)).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (Helper.isHunter((PlayerEntity)player) || faction == VReference.HUNTER_FACTION) {
            VampiricAgeingCapabilityManager.removeModifier(player.func_110148_a(Attributes.field_233818_a_), HUNTER_MAX_HEALTH_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.func_110148_a(Attributes.field_233821_d_), HUNTER_SPEED_INCREASE_UUID);
            player.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier(HUNTER_MAX_HEALTH_UUID, "HUNTER_AGE_MAX_HEALTH_INCREASE", ((Double)((List)HunterAgeingConfig.maxHealthIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.func_110148_a(Attributes.field_233821_d_).func_233769_c_(new AttributeModifier(HUNTER_SPEED_INCREASE_UUID, "HUNTER_AGE_SPEED_INCREASE", ((Double)((List)HunterAgeingConfig.movementSpeedBonus.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADDITION));
            int cumulativeTaintedBloodAge = CapabilityHelper.getCumulativeTaintedAge((PlayerEntity)player);
            VampiricAgeingCapabilityManager.removeModifier(player.func_110148_a(Attributes.field_233823_f_), HUNTER_TAINTED_DAMAGE_INCREASE_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.func_110148_a(Attributes.field_233821_d_), HUNTER_TAINTED_MOVEMENT_SPEED_INCREASE_UUID);
            VampiricAgeingCapabilityManager.removeModifier(player.func_110148_a(Attributes.field_233818_a_), HUNTER_TAINTED_MAX_HEALTH_INCREASE_UUID);
            player.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier(HUNTER_TAINTED_DAMAGE_INCREASE_UUID, "HUNTER_TAINTED_DAMAGE_INCREASE", ((Double)((List)HunterAgeingConfig.taintedDamageBonuses.get()).get(cumulativeTaintedBloodAge)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier(HUNTER_TAINTED_MAX_HEALTH_INCREASE_UUID, "HUNTER_TAINTED_MAX_HEALTH_INCREASE", ((Double)((List)HunterAgeingConfig.taintedBloodMaxHealthIncreases.get()).get(cumulativeTaintedBloodAge)).doubleValue(), AttributeModifier.Operation.ADDITION));
            player.func_110148_a(Attributes.field_233821_d_).func_233769_c_(new AttributeModifier(HUNTER_TAINTED_MOVEMENT_SPEED_INCREASE_UUID, "HUNTER_TAINTED_MOVEMENT_SPEED_INCREASE", ((Double)((List)HunterAgeingConfig.taintedBloodMovementSpeedIncreases.get()).get(cumulativeTaintedBloodAge)).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
    }

    public static void checkSkills(int age, ServerPlayerEntity player) {
        int unlockedSkills = 0;
        if (Helper.isVampire((PlayerEntity)player)) {
            unlockedSkills = VampirePlayer.getOpt((PlayerEntity)player).map(vamp -> {
                ISkillHandler handler = vamp.getSkillHandler();
                int unlockedSkillsCount = 0;
                if (age >= (Integer)CommonConfig.drainBloodActionRank.get()) {
                    handler.enableSkill((ISkill)VampiricAgeingSkills.BLOOD_DRAIN_SKILL.get());
                    ++unlockedSkillsCount;
                } else {
                    handler.disableSkill((ISkill)VampiricAgeingSkills.BLOOD_DRAIN_SKILL.get());
                }
                if (age >= (Integer)CommonConfig.celerityActionRank.get()) {
                    handler.enableSkill((ISkill)VampiricAgeingSkills.CELERTIY_ACTION.get());
                    ++unlockedSkillsCount;
                } else {
                    handler.disableSkill((ISkill)VampiricAgeingSkills.CELERTIY_ACTION.get());
                }
                return unlockedSkillsCount;
            }).orElse(0);
        } else if (Helper.isHunter((PlayerEntity)player)) {
            unlockedSkills = HunterPlayer.getOpt((PlayerEntity)player).map(hunter -> {
                ISkillHandler handler = hunter.getSkillHandler();
                int unlockedSkillsCount = 0;
                if (age >= (Integer)HunterAgeingConfig.taintedBloodBottleAge.get()) {
                    handler.enableSkill((ISkill)VampiricAgeingSkills.TAINTED_BLOOD_SKILL.get());
                    ++unlockedSkillsCount;
                } else {
                    handler.disableSkill((ISkill)VampiricAgeingSkills.TAINTED_BLOOD_SKILL.get());
                }
                int cumulativeAge = CapabilityHelper.getCumulativeTaintedAge((PlayerEntity)player);
                if (cumulativeAge >= (Integer)HunterAgeingConfig.hunterTeleportActionAge.get()) {
                    handler.enableSkill((ISkill)VampiricAgeingSkills.HUNTER_TELEPORT_SKILL.get());
                    ++unlockedSkillsCount;
                } else {
                    handler.disableSkill((ISkill)VampiricAgeingSkills.HUNTER_TELEPORT_SKILL.get());
                }
                if (cumulativeAge >= (Integer)HunterAgeingConfig.limitedBatModeAge.get()) {
                    handler.enableSkill((ISkill)VampiricAgeingSkills.LIMITED_BAT_MODE_SKILL.get());
                    ++unlockedSkillsCount;
                } else {
                    handler.disableSkill((ISkill)VampiricAgeingSkills.LIMITED_BAT_MODE_SKILL.get());
                }
                return unlockedSkillsCount;
            }).orElse(0);
        }
        int finalUnlockedSkills = unlockedSkills;
        VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(ageCap -> ageCap.setAgeSkills(finalUnlockedSkills));
        VampiricAgeingCapabilityManager.syncAgeCapNoChange((PlayerEntity)player);
    }

    public static void removeModifier(ModifiableAttributeInstance att, UUID uuid) {
        AttributeModifier m = att.func_111127_a(uuid);
        if (m != null) {
            att.func_111124_b(m);
        }
    }

    public static void incrementInfected(ServerPlayerEntity player) {
        VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(age -> {
            age.setInfected(age.getInfected() + 1);
            VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)player);
            if (VampiricAgeingCapabilityManager.shouldIncreaseRankInfected((PlayerEntity)player)) {
                VampiricAgeingCapabilityManager.increaseAge(player);
            }
        });
    }

    public static void increaseDrainedBlood(ServerPlayerEntity player, int amount) {
        VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(age -> {
            age.setDrained(age.getDrained() + amount);
            VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)player);
            if (VampiricAgeingCapabilityManager.shouldIncreaseRankDrained((PlayerEntity)player)) {
                VampiricAgeingCapabilityManager.increaseAge(player);
            }
        });
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        AgeingCapabilityProvider provider = new AgeingCapabilityProvider();
        if (event.getObject() instanceof PlayerEntity || event.getObject() instanceof AdvancedVampireEntity || event.getObject() instanceof AdvancedVampireEntity.IMob) {
            event.addCapability(AGEING_KEY, (ICapabilityProvider)provider);
        }
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IAgeingCapability.class, (Capability.IStorage)new Storage(), AgeingCapability::new);
    }

    @SubscribeEvent
    public static void onPotionEffectRemove(PotionEvent.PotionRemoveEvent event) {
        if (((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && event.getPotion() == ModEffects.SANGUINARE.get() && event.getEntity() instanceof PlayerEntity && !event.getEntity().func_130014_f_().field_72995_K) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            player.getPersistentData().func_82580_o("AGE");
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getOriginal()).ifPresent(oldAge -> {
            IAgeingCapability newAgeCap = (IAgeingCapability)VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getPlayer()).orElse((Object)new AgeingCapability());
            CompoundNBT ageTag = (CompoundNBT)oldAge.serializeNBT();
            newAgeCap.deserializeNBT((INBT)ageTag);
            VampiricAgeingCapabilityManager.syncAgeCap(event.getPlayer());
        });
    }

    @SubscribeEvent
    public static void onCoffinInteract(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (Helper.isVampire((PlayerEntity)player) && !player.func_130014_f_().field_72995_K && player.func_130014_f_().func_180495_p(event.getPos()).func_177230_c() instanceof CoffinBlock && VampiricAgeingCapabilityManager.canAge((LivingEntity)player)) {
            int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
            if (((Boolean)CommonConfig.timeBasedIncrease.get()).booleanValue()) {
                int ticksAlive = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getPlayer()).map(ageCap -> ageCap.getTime()).orElse(0);
                int secondsForNextAge = ((Integer)((List)CommonConfig.ticksForNextAge.get()).get(age) - ticksAlive) / 20;
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampiricageing.progress_ticks", new Object[]{secondsForNextAge}).func_240699_a_(TextFormatting.DARK_RED), Util.field_240973_b_);
            }
            if (((Boolean)CommonConfig.biteBasedIncrease.get()).booleanValue()) {
                int infected = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getPlayer()).map(ageCap -> ageCap.getInfected()).orElse(0);
                int infectedForNextAge = (Integer)((List)CommonConfig.infectedForNextAge.get()).get(age) - infected;
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampiricageing.progress_infected", new Object[]{infectedForNextAge}).func_240699_a_(TextFormatting.DARK_RED), Util.field_240973_b_);
            }
            if (((Boolean)CommonConfig.drainBasedIncrease.get()).booleanValue()) {
                int drained = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getPlayer()).map(ageCap -> ageCap.getDrained()).orElse(0);
                int drainedForNextAge = (Integer)((List)CommonConfig.drainedBloodForNextAge.get()).get(age) - drained;
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampiricageing.progress_drained", new Object[]{drainedForNextAge}).func_240699_a_(TextFormatting.DARK_RED), Util.field_240973_b_);
            }
            if (((Boolean)CommonConfig.huntingBasedIncrease.get()).booleanValue()) {
                int hunted = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getPlayer()).map(ageCap -> ageCap.getHunted()).orElse(0);
                int huntedForNextAge = (Integer)((List)CommonConfig.huntedForNextAge.get()).get(age) - hunted;
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampiricageing.progress_hunted_vampire", new Object[]{huntedForNextAge}).func_240699_a_(TextFormatting.DARK_RED), Util.field_240973_b_);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (((Boolean)CommonConfig.huntingBasedIncrease.get()).booleanValue() && event.getSource().func_76346_g() instanceof ServerPlayerEntity && Helper.isVampire((Entity)event.getSource().func_76346_g()) && VampiricAgeingCapabilityManager.canAge((LivingEntity)event.getSource().func_76346_g())) {
            int pointWorth;
            if (event.getEntity().func_200600_R().func_220341_a(EntityTypeTagProvider.pettyHuntVampire)) {
                pointWorth = (Integer)CommonConfig.pettyHuntWorth.get();
            } else if (event.getEntity().func_200600_R().func_220341_a(EntityTypeTagProvider.commonHuntVampire)) {
                pointWorth = (Integer)CommonConfig.commonHuntWorth.get();
            } else if (event.getEntity().func_200600_R().func_220341_a(EntityTypeTagProvider.greaterHuntVampire)) {
                pointWorth = (Integer)CommonConfig.greaterHuntWorth.get();
            } else {
                return;
            }
            CapabilityHelper.increasePoints((ServerPlayerEntity)event.getSource().func_76346_g(), pointWorth);
        }
    }

    @SubscribeEvent
    public static void sireBloodInteract(PlayerInteractEvent event) {
        int age;
        PlayerEntity player = event.getPlayer();
        if (player.func_225608_bj_() && ((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && Helper.isVampire((PlayerEntity)player) && event.getHand() == Hand.MAIN_HAND && event.getItemStack().func_77973_b() == Items.field_151069_bo && (age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0).intValue()) > 1 && VampirePlayer.getOpt((PlayerEntity)player).map(vamp -> vamp.getBloodLevel() > 8).orElse(false).booleanValue()) {
            ItemStack mainHandStack = player.func_184614_ca();
            mainHandStack.func_190918_g(1);
            ItemStack stack = ((BloodBottleItem)ModItems.BLOOD_BOTTLE.get()).func_190903_i();
            stack.func_196082_o().func_74768_a("AGE", --age);
            stack.func_196085_b(4);
            player.func_191521_c(stack);
            VampirePlayer.getOpt((PlayerEntity)player).ifPresent(vamp -> vamp.removeBlood(0.5f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity && ((Boolean)CommonConfig.deathReset.get()).booleanValue()) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(age -> {
                age.setAge(0);
                VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)player);
            });
        }
        LivingEntity dead = event.getEntityLiving();
        if (!dead.func_130014_f_().field_72995_K && event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getSource().func_76346_g();
            if (((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && player.func_184592_cb().func_77973_b() == Items.field_151069_bo && Helper.isVampire((Entity)dead) && (dead instanceof AdvancedVampireEntity || dead instanceof PlayerEntity)) {
                int age2 = VampiricAgeingCapabilityManager.getAge(dead).map(ageCap -> ageCap.getAge()).orElse(0);
                ItemStack offHandStack = player.func_184592_cb();
                offHandStack.func_190918_g(1);
                ItemStack stack = ((BloodBottleItem)ModItems.BLOOD_BOTTLE.get()).func_190903_i();
                stack.func_196082_o().func_74768_a("AGE", age2);
                stack.func_196085_b(1);
                player.func_191521_c(stack);
            }
        }
        if (dead.getPersistentData().func_74764_b("AGE")) {
            dead.getPersistentData().func_82580_o("AGE");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void tooltipEvent(ItemTooltipEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() == ModItems.BLOOD_BOTTLE.get() && ((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && stack.func_196082_o().func_74764_b("AGE")) {
            int age = stack.func_196082_o().func_74762_e("AGE");
            event.getToolTip().add(new TranslationTextComponent("text.vampiricageing.blood_rank").func_240702_b_(String.valueOf(age)));
        }
    }

    @SubscribeEvent
    public static void useItem(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntityLiving();
        ItemStack stack = event.getItem();
        if (((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && stack.func_196082_o().func_74764_b("AGE") && entity instanceof PlayerEntity && Helper.isVampire((Entity)entity) && event.getItem().func_77973_b() == ModItems.BLOOD_BOTTLE.get()) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            int age = stack.func_196082_o().func_74762_e("AGE");
            int ageRank = VampiricAgeingCapabilityManager.getAge(entity).map(ageCap -> ageCap.getAge()).orElse(0);
            stack.func_196082_o().func_82580_o("AGE");
            if (age > 0 && age > ageRank) {
                VampiricAgeingCapabilityManager.getAge(entity).ifPresent(ageCap -> {
                    ageCap.setAge(age);
                    VampiricAgeingCapabilityManager.syncAgeCap(player);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        ServerPlayerEntity player;
        if (event.player.field_70170_p.func_82737_E() % 100L == 0L && event.player instanceof ServerPlayerEntity && ((Boolean)CommonConfig.timeBasedIncrease.get()).booleanValue() && event.phase == TickEvent.Phase.END && VampiricAgeingCapabilityManager.canAge((LivingEntity)(player = (ServerPlayerEntity)event.player)) && Helper.isVampire((PlayerEntity)player)) {
            VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(age -> {
                age.setTime(age.getTime() + 100);
                VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)player);
                if (VampiricAgeingCapabilityManager.shouldIncreaseRankTicks((PlayerEntity)player)) {
                    VampiricAgeingCapabilityManager.increaseAge(player);
                }
            });
        }
        if (event.player.field_70173_aa % 20 == 0 && ((Boolean)CommonConfig.deadlySourcesFastDrainExhaustion.get()).booleanValue()) {
            if (!event.player.func_70644_a((Effect)ModEffects.GARLIC.get())) {
                return;
            }
            if (!Helper.isVampire((PlayerEntity)event.player)) {
                return;
            }
            int age2 = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.player).map(ageCap -> ageCap.getAge()).orElse(0);
            VampirePlayer.getOpt((PlayerEntity)event.player).ifPresent(vamp -> vamp.addExhaustion(((Double)((List)CommonConfig.amountExhaustionDrainFromSources.get()).get(age2)).floatValue()));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)event.getEntity());
        } else {
            VampiricAgeingCapabilityManager.changeUpStep(event.getPlayer(), null);
        }
    }

    @SubscribeEvent
    public static void onPlayerDimChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTrackingEvent(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof ServerPlayerEntity) {
            VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onChangeFaction(FactionEvent.FactionLevelChanged event) {
        if (event.getNewLevel() == 0 || event.getCurrentFaction() != event.getOldFaction() && event.getOldFaction() != null) {
            VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getPlayer().getPlayer()).ifPresent(age -> {
                age.setAge(0);
                IPlayableFaction faction = event.getOldFaction();
                VampiricAgeingCapabilityManager.syncAgeCap(event.getPlayer().getPlayer(), faction);
                PlayerEntity player = event.getPlayer().getPlayer();
                if (faction == VReference.HUNTER_FACTION) {
                    if (player.func_70644_a((Effect)com.doctor.vampiricageing.init.ModEffects.TAINTED_BLOOD_EFFECT.get())) {
                        player.func_195063_d((Effect)com.doctor.vampiricageing.init.ModEffects.TAINTED_BLOOD_EFFECT.get());
                    }
                    age.setTransformed(false);
                }
                VampiricAgeingCapabilityManager.syncAgeCap(player, faction);
            });
        } else if (event.getNewLevel() > 0 && event.getCurrentFaction() == VReference.VAMPIRE_FACTION && ((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && event.getPlayer().getPlayer().getPersistentData().func_74764_b("AGE")) {
            int sireAge = event.getPlayer().getPlayer().getPersistentData().func_74762_e("AGE");
            VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getPlayer().getPlayer()).ifPresent(age -> {
                age.setAge(sireAge);
                VampiricAgeingCapabilityManager.syncAgeCap(event.getPlayer().getPlayer());
                event.getPlayer().getPlayer().getPersistentData().func_82580_o("AGE");
            });
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        if (Helper.isVampire((Entity)event.getEntityLiving()) && event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            int age = VampiricAgeingCapabilityManager.getAge(event.getEntityLiving()).map(ageCap -> ageCap.getAge()).orElse(0);
            if (event.getSource() == VReference.SUNDAMAGE) {
                event.setAmount(event.getAmount() / ((Double)((List)CommonConfig.sunDamageReduction.get()).get(age)).floatValue());
            } else if (event.getSource() == VReference.VAMPIRE_IN_FIRE || event.getSource() == VReference.VAMPIRE_ON_FIRE || event.getSource() == VReference.HOLY_WATER) {
                if (((Boolean)CommonConfig.rageModeWeaknessToggle.get()).booleanValue() && VampirePlayer.getOpt((PlayerEntity)player).map(vamp -> vamp.getActionHandler().isActionActive((ILastingAction)VampireActions.VAMPIRE_RAGE.get())).orElse(false).booleanValue() && ((Double)((List)CommonConfig.genericVampireWeaknessReduction.get()).get(age)).floatValue() < 1.0f) {
                    return;
                }
                if (event.getSource() != VReference.HOLY_WATER && ((Boolean)CommonConfig.deadlySourcesFastDrainExhaustion.get()).booleanValue() && event.getEntity() instanceof PlayerEntity) {
                    VampirePlayer.getOpt((PlayerEntity)player).ifPresent(vamp -> vamp.addExhaustion(((Double)((List)CommonConfig.amountExhaustionDrainFromSources.get()).get(age)).floatValue()));
                }
                event.setAmount(event.getAmount() / ((Double)((List)CommonConfig.genericVampireWeaknessReduction.get()).get(age)).floatValue());
            } else if (event.getSource() == DamageSource.field_76366_f && ((Boolean)CommonConfig.harsherOutOfBlood.get()).booleanValue() && age > 0) {
                event.setAmount(event.getAmount() * (float)age);
            } else if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g().func_200600_R().func_220341_a((ITag)ModTags.Entities.HUNTER) && ((Boolean)CommonConfig.shouldAgeIncreaseHunterMobDamage.get()).booleanValue()) {
                event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.damageMultiplierFromHunters.get()).get(age)).floatValue());
            } else if (!Helper.canKillVampires((DamageSource)event.getSource()) && event.getAmount() >= event.getEntityLiving().func_110143_aJ() && ((Boolean)CommonConfig.shouldOnlyDieFromKillingSources.get()).booleanValue() && age >= (Integer)CommonConfig.shouldOnlyDieFromKillingSourcesAgeRank.get()) {
                event.getEntityLiving().func_70606_j(1.0f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        if (((Boolean)CommonConfig.shouldAgeAffectHealing.get()).booleanValue() && Helper.isVampire((Entity)event.getEntity())) {
            int age = VampiricAgeingCapabilityManager.getAge(event.getEntityLiving()).map(ageCap -> ageCap.getAge()).orElse(0);
            event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.ageHealingMultiplier.get()).get(age)).floatValue());
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        PlayerEntity player;
        LivingEntity target = event.getEntityLiving();
        Entity source = event.getSource().func_76346_g();
        if (source instanceof PlayerEntity && Helper.isVampire((Entity)source)) {
            player = (PlayerEntity)source;
            VampirePlayer.getOpt((PlayerEntity)player).ifPresent(vamp -> {
                if (vamp.getActionHandler().isActionActive((ILastingAction)VampiricAgeingActions.DRAIN_BLOOD_ACTION.get())) {
                    IVampirePlayer.BITE_TYPE biteType = vamp.determineBiteType(target);
                    int blood = 0;
                    float saturationMod = 1.0f;
                    if (biteType == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER) {
                        blood = VampirePlayer.getOpt((PlayerEntity)((PlayerEntity)target)).map(v -> v.onBite((IVampire)vamp)).orElse(0);
                        saturationMod = VampirePlayer.getOpt((PlayerEntity)((PlayerEntity)target)).map(VampirePlayer::getBloodSaturation).orElse(Float.valueOf(0.0f)).floatValue();
                        vamp.drinkBlood(blood, saturationMod);
                    } else if (biteType == IVampirePlayer.BITE_TYPE.HUNTER_CREATURE && target instanceof PlayerEntity) {
                        PlayerEntity targetPlayer = (PlayerEntity)target;
                        targetPlayer.func_71024_bL().func_75113_a(1.0f);
                        vamp.drinkBlood(1, 0.1f);
                    } else if (biteType == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE) {
                        LazyOptional opt = ExtendedCreature.getSafe((Entity)target);
                        blood = opt.map(creature -> creature.onBite((IVampire)vamp)).orElse(0);
                        saturationMod = opt.map(IBiteableEntity::getBloodSaturation).orElse(Float.valueOf(0.0f)).floatValue();
                        vamp.drinkBlood(blood, saturationMod);
                    }
                }
            });
        }
        if (source instanceof AdvancedVampireEntity && ((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && target instanceof ServerPlayerEntity && Helper.canBecomeVampire((PlayerEntity)((PlayerEntity)target))) {
            player = (ServerPlayerEntity)target;
            AdvancedVampireEntity vamp2 = (AdvancedVampireEntity)source;
            VampiricAgeingCapabilityManager.getAge((LivingEntity)vamp2).ifPresent(arg_0 -> VampiricAgeingCapabilityManager.lambda$onHurt$46(vamp2, (ServerPlayerEntity)player, arg_0));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof AdvancedVampireEntity && ((Boolean)CommonConfig.advancedVampireAge.get()).booleanValue() && !event.getEntity().func_130014_f_().field_72995_K) {
            AdvancedVampireEntity vamp = (AdvancedVampireEntity)event.getEntity();
            VampiricAgeingCapabilityManager.getAge((LivingEntity)vamp).ifPresent(vampireAge -> {
                if (vampireAge.getAge() != 0) {
                    return;
                }
                List percentages = (List)CommonConfig.percentageAdvancedVampireAges.get();
                double random = vamp.func_70681_au().nextDouble();
                if (random <= (Double)percentages.get(0)) {
                    vampireAge.setAge(1);
                } else if (random <= (Double)percentages.get(1) + (Double)percentages.get(0) && random > (Double)percentages.get(0)) {
                    vampireAge.setAge(2);
                } else if (random <= (Double)percentages.get(2) + (Double)percentages.get(1) && random > (Double)percentages.get(1)) {
                    vampireAge.setAge(3);
                } else if (random <= (Double)percentages.get(3) + (Double)percentages.get(2) && random > (Double)percentages.get(2)) {
                    vampireAge.setAge(4);
                } else if (random <= (Double)percentages.get(4) + (Double)percentages.get(3) && random > (Double)percentages.get(3)) {
                    vampireAge.setAge(5);
                } else {
                    vampireAge.setAge(0);
                    return;
                }
                VampiricAgeingCapabilityManager.removeModifier(vamp.func_110148_a(Attributes.field_233818_a_), MAX_HEALTH_UUID);
                VampiricAgeingCapabilityManager.removeModifier(vamp.func_110148_a(Attributes.field_233823_f_), ATTACK_DAMAGE_UUID);
                VampiricAgeingCapabilityManager.removeModifier(vamp.func_110148_a(Attributes.field_233820_c_), KNOCKBACK_RESISTANCE_UUID);
                VampiricAgeingCapabilityManager.removeModifier(vamp.func_110148_a(Attributes.field_233821_d_), AGE_ADVANCED_SPEED_INCREASE);
                float ageMultiplier = Math.min(1.0f, (float)vampireAge.getAge() / 2.0f);
                vamp.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier(MAX_HEALTH_UUID, "AGE_VAMPIRE_HEALTH_INCREASE", (double)ageMultiplier, AttributeModifier.Operation.MULTIPLY_BASE));
                vamp.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier(ATTACK_DAMAGE_UUID, "AGE_VAMPIRE_DAMAGE_INCREASE", (double)ageMultiplier, AttributeModifier.Operation.MULTIPLY_BASE));
                vamp.func_110148_a(Attributes.field_233820_c_).func_233769_c_(new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "AGE_VAMPIRE_KNOCKBACK_RESISTANCE", 0.25 * (double)ageMultiplier, AttributeModifier.Operation.ADDITION));
                vamp.func_70606_j(vamp.func_110138_aP());
                if (vampireAge.getAge() > 2) {
                    vamp.func_110148_a(Attributes.field_233821_d_).func_233769_c_(new AttributeModifier(AGE_ADVANCED_SPEED_INCREASE, "AGE_VAMPIRE_SPEED_INCREASE", 0.2 * (double)ageMultiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
            });
        }
    }

    public static void syncAgeCap(PlayerEntity player) {
        IAgeingCapability cap = (IAgeingCapability)VampiricAgeingCapabilityManager.getAge((LivingEntity)player).orElse((Object)new AgeingCapability());
        CompoundNBT tag = (CompoundNBT)cap.serializeNBT();
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncCapabilityPacket(tag));
            VampiricAgeingCapabilityManager.onAgeChange(serverPlayer, null);
        }
    }

    public static void syncAgeCap(PlayerEntity player, IPlayableFaction<?> faction) {
        IAgeingCapability cap = (IAgeingCapability)VampiricAgeingCapabilityManager.getAge((LivingEntity)player).orElse((Object)new AgeingCapability());
        CompoundNBT tag = (CompoundNBT)cap.serializeNBT();
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncCapabilityPacket(tag));
            VampiricAgeingCapabilityManager.onAgeChange(serverPlayer, faction);
        }
    }

    public static void syncAgeCapNoChange(PlayerEntity player) {
        IAgeingCapability cap = (IAgeingCapability)VampiricAgeingCapabilityManager.getAge((LivingEntity)player).orElse((Object)new AgeingCapability());
        CompoundNBT tag = (CompoundNBT)cap.serializeNBT();
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncCapabilityPacket(tag));
        }
    }

    private static /* synthetic */ void lambda$onHurt$46(AdvancedVampireEntity vamp, ServerPlayerEntity player, IAgeingCapability vampireAge) {
        if (vampireAge.getAge() > 1 && (double)vamp.func_70681_au().nextFloat() > 0.85) {
            SanguinareEffect.addRandom((LivingEntity)player, (boolean)true);
            player.getPersistentData().func_82580_o("AGE");
            player.getPersistentData().func_74768_a("AGE", vampireAge.getAge() - 1);
        }
    }

    private static class Storage
    implements Capability.IStorage<IAgeingCapability> {
        private Storage() {
        }

        public void readNBT(Capability<IAgeingCapability> capability, IAgeingCapability instance, Direction side, INBT nbt) {
            ((VampirePlayer)instance).loadData((CompoundNBT)nbt);
        }

        public INBT writeNBT(Capability<IAgeingCapability> capability, IAgeingCapability instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            ((VampirePlayer)instance).saveData(nbt);
            return nbt;
        }
    }
}

