/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.capabilities;

import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.WerewolvesAgeingConfig;
import com.doctor.vampiricageing.data.EntityTypeTagProvider;
import de.teamlapen.werewolves.blocks.StoneAltarFireBowlBlock;
import de.teamlapen.werewolves.util.BiteDamageSource;
import de.teamlapen.werewolves.util.Helper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WerewolfAgeingManager {
    public static boolean shouldIncreaseRankDevoured(PlayerEntity player) {
        return VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(age -> age.getDevoured() >= (Integer)((List)WerewolvesAgeingConfig.devouredForNextAge.get()).get(age.getAge())).orElse(false);
    }

    public static void increasePoints(ServerPlayerEntity player, int points) {
        VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(age -> {
            age.setDevoured(age.getDevoured() + points);
            VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)player);
            if (WerewolfAgeingManager.shouldIncreaseRankDevoured((PlayerEntity)player)) {
                VampiricAgeingCapabilityManager.increaseAge(player);
            }
        });
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (((Boolean)WerewolvesAgeingConfig.devourBasedAgeing.get()).booleanValue() && event.getSource().func_76346_g() instanceof ServerPlayerEntity && Helper.isWerewolf((Entity)event.getSource().func_76346_g()) && event.getSource() instanceof BiteDamageSource && VampiricAgeingCapabilityManager.canAge((LivingEntity)event.getSource().func_76346_g())) {
            int pointWorth = event.getEntity().func_200600_R().func_220341_a(EntityTypeTagProvider.pettyDevour) ? (Integer)WerewolvesAgeingConfig.pettyDevourWorth.get() : (event.getEntity().func_200600_R().func_220341_a(EntityTypeTagProvider.commonDevour) ? (Integer)WerewolvesAgeingConfig.commonDevourWorth.get() : (event.getEntity().func_200600_R().func_220341_a(EntityTypeTagProvider.greaterDevour) ? (Integer)WerewolvesAgeingConfig.greaterDevourWorth.get() : (event.getEntity().func_200600_R().func_220341_a(EntityTypeTagProvider.exquisiteDevour) ? (Integer)WerewolvesAgeingConfig.exquisiteDevourWorth.get() : 0)));
            WerewolfAgeingManager.increasePoints((ServerPlayerEntity)event.getSource().func_76346_g(), pointWorth);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (event.getHand() == Hand.MAIN_HAND && Helper.isWerewolf((PlayerEntity)player) && !player.func_130014_f_().field_72995_K && player.func_130014_f_().func_180495_p(event.getPos()).func_177230_c() instanceof StoneAltarFireBowlBlock && VampiricAgeingCapabilityManager.canAge((LivingEntity)player)) {
            int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getPlayer()).map(ageCap -> ageCap.getAge()).orElse(0);
            if (((Boolean)WerewolvesAgeingConfig.devourBasedAgeing.get()).booleanValue()) {
                int devourPoints = VampiricAgeingCapabilityManager.getAge((LivingEntity)event.getPlayer()).map(ageCap -> ageCap.getDevoured()).orElse(0);
                int devouredForNextAge = (Integer)((List)WerewolvesAgeingConfig.devouredForNextAge.get()).get(age) - devourPoints;
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampiricageing.progress_devour", new Object[]{devouredForNextAge}).func_240699_a_(TextFormatting.DARK_RED), Util.field_240973_b_);
            }
        }
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        if (event.getSource() instanceof BiteDamageSource && event.getSource().func_76346_g() instanceof PlayerEntity && Helper.isWerewolf((Entity)event.getSource().func_76346_g()) && !event.getEntity().func_130014_f_().field_72995_K) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
            player.func_70691_i(((Double)((List)WerewolvesAgeingConfig.healonBiteAmount.get()).get(age)).floatValue());
            if (((Boolean)WerewolvesAgeingConfig.bitingGivesFood.get()).booleanValue() && age >= (Integer)WerewolvesAgeingConfig.rankForBiteFood.get()) {
                FoodStats foodData = player.func_71024_bL();
                foodData.func_75122_a(((Integer)WerewolvesAgeingConfig.biteNutrition.get()).intValue(), ((Double)WerewolvesAgeingConfig.biteSaturation.get()).floatValue());
            }
        }
    }

    @SubscribeEvent
    public void onFootEatenFinish(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntityLiving() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)((PlayerEntity)event.getEntity()))) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (Helper.isRawMeat((ItemStack)event.getItem())) {
                int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
                int multiplier = (Integer)((List)WerewolvesAgeingConfig.nourishmentMultipliers.get()).get(age) - 1;
                for (int i = 1; i <= multiplier; ++i) {
                    player.func_71024_bL().func_221410_a(event.getItem().func_77973_b(), event.getItem());
                }
            }
        }
    }
}

