/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.client.init;

import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.client.gui.ExtendedGui;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class ClientRenderHandler
extends ExtendedGui {
    private BatEntity entityBat;
    private final Minecraft mc;
    private int screenPercentage = 0;

    public ClientRenderHandler(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderPlayerPreHigh(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        boolean batMode = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(hunter -> hunter.getBatMode()).orElse(false);
        if (batMode) {
            event.setCanceled(true);
            if (this.entityBat == null) {
                this.entityBat = (BatEntity)EntityType.field_200791_e.func_200721_a(event.getEntity().func_130014_f_());
                this.entityBat.func_82236_f(false);
            }
            float partialTicks = event.getPartialRenderTick();
            this.entityBat.field_70760_ar = player.field_70760_ar;
            this.entityBat.field_70761_aq = player.field_70761_aq;
            this.entityBat.field_70173_aa = player.field_70173_aa;
            this.entityBat.field_70125_A = player.field_70125_A;
            this.entityBat.field_70177_z = player.field_70177_z;
            this.entityBat.field_70759_as = player.field_70759_as;
            this.entityBat.field_70126_B = player.field_70126_B;
            this.entityBat.field_70127_C = player.field_70127_C;
            this.entityBat.field_70758_at = player.field_70758_at;
            this.entityBat.func_82142_c(player.func_82150_aj());
            double d0 = MathHelper.func_219803_d((double)partialTicks, (double)this.entityBat.field_70142_S, (double)this.entityBat.func_226277_ct_());
            double d1 = MathHelper.func_219803_d((double)partialTicks, (double)this.entityBat.field_70137_T, (double)this.entityBat.func_226278_cu_());
            double d2 = MathHelper.func_219803_d((double)partialTicks, (double)this.entityBat.field_70136_U, (double)this.entityBat.func_226281_cx_());
            float f = MathHelper.func_219799_g((float)partialTicks, (float)this.entityBat.field_70126_B, (float)this.entityBat.field_70177_z);
            this.mc.func_175598_ae().func_229084_a_((Entity)this.entityBat, d0, d1, d2, f, partialTicks, event.getMatrixStack(), (IRenderTypeBuffer)this.mc.func_228019_au_().func_228487_b_(), this.mc.func_175598_ae().func_229085_a_((Entity)this.entityBat, partialTicks));
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (this.mc.field_71439_g != null && this.mc.field_71439_g.func_70089_S() && VampiricAgeingCapabilityManager.getAge((LivingEntity)this.mc.field_71439_g).map(hunter -> hunter.getBatMode()).orElse(false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            this.screenPercentage = 0;
            return;
        }
        if (event.phase == TickEvent.Phase.END || !((Boolean)HunterAgeingConfig.sunAffectTainted.get()).booleanValue() || !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        IFactionPlayer player = FactionPlayerHandler.getOpt((PlayerEntity)this.mc.field_71439_g).resolve().flatMap(FactionPlayerHandler::getCurrentFactionPlayer).orElse(null);
        if (player instanceof HunterPlayer) {
            this.handleScreenColour((HunterPlayer)player);
        } else {
            this.screenPercentage = 0;
        }
    }

    private void handleScreenColour(HunterPlayer player) {
        VampiricAgeingCapabilityManager.getAge((LivingEntity)player.getRepresentingPlayer()).ifPresent(hunter -> {
            if (hunter.getTicksInSun() / 100 > 0 && !player.getRepresentingPlayer().func_70644_a((Effect)ModEffects.SUNSCREEN.get())) {
                this.screenPercentage = hunter.getTicksInSun() / 50;
                this.screenPercentage = Math.min(this.screenPercentage, (Integer)VampirismConfig.BALANCE.vpMaxYellowBorderPercentage.get());
            } else {
                this.screenPercentage = 0;
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        int percentages = 0;
        int color = 0;
        if (this.screenPercentage > 0) {
            percentages = this.screenPercentage;
            color = -3038;
        }
        if (percentages > 0 && ((Boolean)VampirismConfig.CLIENT.renderScreenOverlay.get()).booleanValue()) {
            RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
            MatrixStack stack = new MatrixStack();
            stack.func_227860_a_();
            RenderSystem.matrixMode((int)5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)this.mc.func_228018_at_().func_198107_o(), (double)this.mc.func_228018_at_().func_198087_p(), (double)0.0, (double)1.0, (double)-1.0);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.loadIdentity();
            GL11.glDisable((int)2929);
            int w = this.mc.func_228018_at_().func_198107_o();
            int h = this.mc.func_228018_at_().func_198087_p();
            int bh = Math.round((float)h / 4.0f * (float)percentages / 100.0f);
            int bw = Math.round((float)w / 8.0f * (float)percentages / 100.0f);
            this.func_238468_a_(stack, 0, 0, w, bh, color, 0);
            this.func_238468_a_(stack, 0, h - bh, w, h, 0, color);
            this.fillGradient2(stack, 0, 0, bw, h, 0, color);
            this.fillGradient2(stack, w - bw, 0, w, h, color, 0);
            GL11.glEnable((int)2929);
            stack.func_227865_b_();
        }
    }
}

