/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.command;

import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import com.doctor.vampiricageing.config.WerewolvesAgeingConfig;
import com.doctor.vampiricageing.init.ModEffects;
import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.util.Helper;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModList;

public class ChangeAgeCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"age").requires(context -> context.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"age", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> ChangeAgeCommand.setAge((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"age"), Lists.newArrayList((Object[])new ServerPlayerEntity[]{((CommandSource)context.getSource()).func_197035_h()})))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> ChangeAgeCommand.setAge((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"age"), EntityArgument.func_197090_e((CommandContext)context, (String)"player")))));
    }

    private static int setAge(CommandContext<CommandSource> context, int age, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            int level = FactionPlayerHandler.getOpt((PlayerEntity)player).map(FactionPlayerHandler::getCurrentLevel).orElse(0);
            if (age < 6 && age >= 0 && level > 0) {
                VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(ageCap -> ageCap.setAge(age));
                VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)player);
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampiricageing.base.age.success", new Object[]{player.func_200200_C_(), age}), true);
                if (!Helper.isHunter((PlayerEntity)player) || !player.func_70644_a((Effect)ModEffects.TAINTED_BLOOD_EFFECT.get())) continue;
                player.func_195063_d((Effect)ModEffects.TAINTED_BLOOD_EFFECT.get());
                continue;
            }
            if (age > 5 || age < 0) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)(players.size() > 1 ? new TranslationTextComponent("command.vampiricageing.failed_to_execute.players.age", new Object[]{player.func_145748_c_()}) : new TranslationTextComponent("command.vampiricageing.failed_to_execute.age")));
                continue;
            }
            if (Helper.isHunter((PlayerEntity)player) && !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
                if (ModList.get().isLoaded("werewolves") && ((Boolean)WerewolvesAgeingConfig.werewolfAgeing.get()).booleanValue()) {
                    ((CommandSource)context.getSource()).func_197021_a((ITextComponent)(players.size() > 1 ? new TranslationTextComponent("command.vampiricageing.failed_to_execute.players.wrong_faction_werewolves_enabled", new Object[]{player.func_145748_c_()}) : new TranslationTextComponent("command.vampiricageing.failed_to_execute.wrong_faction_werewolves_enabled")));
                    continue;
                }
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)(players.size() > 1 ? new TranslationTextComponent("command.vampiricageing.failed_to_execute.players.wrong_faction", new Object[]{player.func_145748_c_()}) : new TranslationTextComponent("command.vampiricageing.failed_to_execute.wrong_faction")));
                continue;
            }
            if (CapabilityHelper.isWerewolfCheckMod((Entity)player) && ((Boolean)WerewolvesAgeingConfig.werewolfAgeing.get()).booleanValue()) {
                if (((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
                    ((CommandSource)context.getSource()).func_197021_a((ITextComponent)(players.size() > 1 ? new TranslationTextComponent("command.vampiricageing.failed_to_execute.players.wrong_faction_hunters_enabled", new Object[]{player.func_145748_c_()}) : new TranslationTextComponent("command.vampiricageing.failed_to_execute.wrong_faction_hunters_enabled")));
                    continue;
                }
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)(players.size() > 1 ? new TranslationTextComponent("command.vampiricageing.failed_to_execute.players.wrong_faction", new Object[]{player.func_145748_c_()}) : new TranslationTextComponent("command.vampiricageing.failed_to_execute.wrong_faction")));
                continue;
            }
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)(players.size() > 1 ? new TranslationTextComponent("command.vampiricageing.failed_to_execute.players", new Object[]{player.func_145748_c_()}) : new TranslationTextComponent("command.vampiricageing.failed_to_execute")));
        }
        return 0;
    }
}

