/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.items;

import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import com.doctor.vampiricageing.init.ModEffects;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TaintedBloodBottleItem
extends Item
implements IFactionExclusiveItem {
    public TaintedBloodBottleItem(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public IFaction<?> getExclusiveFaction() {
        return VReference.HUNTER_FACTION;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!((Boolean)HunterAgeingConfig.taintedBloodAvailable.get()).booleanValue()) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (!Helper.isHunter((PlayerEntity)player)) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
        boolean transformed = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.isTransformed()).orElse(false);
        if (age >= (Integer)HunterAgeingConfig.taintedBloodBottleAge.get() && !transformed) {
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(level, player, hand);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player instanceof IHunterPlayer) {
            return;
        }
        if (!player.func_70089_S() || !((Boolean)HunterAgeingConfig.taintedBloodAvailable.get()).booleanValue()) {
            player.func_184597_cx();
            return;
        }
        int age = VampiricAgeingCapabilityManager.getAge(player).map(ageCap -> ageCap.getAge()).orElse(0);
        if (age >= (Integer)HunterAgeingConfig.taintedBloodBottleAge.get()) {
            player.func_184598_c(player.func_184600_cs());
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity && Helper.isHunter((Entity)entityLiving)) {
            int age = stack.func_77952_i();
            VampiricAgeingCapabilityManager.getAge(entityLiving).ifPresent(hunter -> {
                hunter.setTemporaryTainedTicks((Integer)HunterAgeingConfig.temporaryTaintedBloodBaseTicks.get() * hunter.getAge());
                hunter.setTemporaryTaintedAgeBonus(age);
                entityLiving.func_195064_c(new EffectInstance((Effect)ModEffects.TAINTED_BLOOD_EFFECT.get(), (Integer)HunterAgeingConfig.temporaryTaintedBloodBaseTicks.get() * hunter.getAge(), 0, false, false));
                VampiricAgeingCapabilityManager.syncAgeCap((PlayerEntity)entityLiving);
                stack.func_190918_g(1);
            });
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public int func_77626_a(ItemStack stack) {
        return 45;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> components, ITooltipFlag tf) {
        components.add((ITextComponent)new TranslationTextComponent("text.vampiricageing.tainted_blood_useage", new Object[]{HunterAgeingConfig.taintedBloodBottleAge.get()}).func_240699_a_(TextFormatting.GRAY));
        components.add((ITextComponent)new TranslationTextComponent("text.vampiricageing.tainted_blood_rank", new Object[]{stack.func_77952_i()}).func_240699_a_(TextFormatting.RED));
        super.func_77624_a(stack, world, components, tf);
    }
}

