/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.mixin;

import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.DamageHandler;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DamageHandler.class})
public abstract class DamageHandlerMixin {
    @Inject(method={"affectEntityHolyWaterSplash(Lnet/minecraft/entity/LivingEntity;Lde/teamlapen/vampirism/api/EnumStrength;DZLnet/minecraft/entity/LivingEntity;)V"}, at={@At(value="INVOKE", target="Lde/teamlapen/vampirism/util/Helper;isVampire(Lnet/minecraft/entity/Entity;)Z")}, remap=false)
    private static void affectEntityHolyWaterSplash(LivingEntity entity, EnumStrength strength, double distSq, boolean directHit, LivingEntity source, CallbackInfo ci) {
        PlayerEntity player;
        int cumulative;
        if (entity instanceof PlayerEntity && (cumulative = CapabilityHelper.getCumulativeTaintedAge(player = (PlayerEntity)entity)) >= (Integer)HunterAgeingConfig.taintedBloodHolyWaterAffectedAge.get()) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            double amount = affect * ((double)((Integer)VampirismConfig.BALANCE.holyWaterSplashDamage.get()).intValue() * (strength == EnumStrength.WEAK ? 1.0 : (strength == EnumStrength.MEDIUM ? (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get() : (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get() * (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get()))) + 0.5;
            amount = DamageHandler.scaleDamageWithLevel((int)cumulative, (int)10, (double)(amount * 0.6), (double)(amount * 1.15));
            entity.func_70097_a(VReference.HOLY_WATER, (float)amount);
            if (strength.isStrongerThan(EnumStrength.WEAK)) {
                entity.func_195064_c(new EffectInstance(Effects.field_76431_k, ((Integer)VampirismConfig.BALANCE.holyWaterNauseaDuration.get()).intValue(), 2));
            }
            if (strength.isStrongerThan(EnumStrength.MEDIUM)) {
                entity.func_195064_c(new EffectInstance(Effects.field_76440_q, ((Integer)VampirismConfig.BALANCE.holyWaterBlindnessDuration.get()).intValue(), 1));
            }
        }
    }
}

