/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.mixin;

import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import com.doctor.vampiricageing.data.ItemTagProvider;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.FoodStats;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Shadow
    @Final
    private PlayerAbilities field_71075_bZ;
    @Shadow
    protected FoodStats field_71100_bB;

    protected PlayerMixin(EntityType<? extends LivingEntity> p_20966_, World p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Redirect(method={"checkMovementStatistics"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;causeFoodExhaustion(F)V"))
    private void causeFoodExhaustion(PlayerEntity instance, float amount) {
        if (this.field_71075_bZ.field_75102_a) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (Helper.isHunter((Entity)this) && ((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            int age = VampiricAgeingCapabilityManager.getAge(this).map(ageCap -> ageCap.getAge()).orElse(0);
            this.field_71100_bB.func_75113_a(amount * ((Double)((List)HunterAgeingConfig.fasterExhaustionAmounts.get()).get(age)).floatValue());
        } else {
            this.field_71100_bB.func_75113_a(amount);
        }
    }

    @Inject(method={"eat"}, at={@At(value="HEAD")}, cancellable=true)
    private void eat(World world, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        PlayerEntity player;
        if (!stack.func_77973_b().func_206844_a(ItemTagProvider.taintedFood) && ((Boolean)HunterAgeingConfig.reducedBenefitFromNormalFoods.get()).booleanValue() && Helper.isHunter((PlayerEntity)(player = (PlayerEntity)this))) {
            Food food = stack.func_77973_b().func_219967_s();
            int cumulativeAge = CapabilityHelper.getCumulativeTaintedAge(player);
            FoodStats stats = player.func_71024_bL();
            stats.func_75122_a(food.func_221466_a() - (Integer)((List)HunterAgeingConfig.taintedAgeNutritionReduction.get()).get(cumulativeAge), food.func_221469_b() - ((Double)((List)HunterAgeingConfig.taintedAgeSaturationReduction.get()).get(cumulativeAge)).floatValue());
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
            world.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)player, stack);
            }
            cir.setReturnValue((Object)super.func_213357_a(world, stack));
        }
    }
}

