/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.mixin;

import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.CommonConfig;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VampirePlayer.class})
public abstract class VampirePlayerMixin
extends VampirismPlayer<IVampirePlayer>
implements IVampirePlayer {
    public VampirePlayerMixin(PlayerEntity player) {
        super(player);
    }

    @Inject(method={"drinkBlood"}, at={@At(value="HEAD")}, remap=false)
    private void drinkBlood(int amt, float saturationMod, boolean useRemaining, CallbackInfo ci) {
        if (((Boolean)CommonConfig.drainBasedIncrease.get()).booleanValue() && !this.player.func_130014_f_().field_72995_K && VampiricAgeingCapabilityManager.canAge((LivingEntity)this.player)) {
            VampiricAgeingCapabilityManager.increaseDrainedBlood((ServerPlayerEntity)this.player, amt);
        }
    }

    @Inject(method={"getDbnoDuration"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    private void getDbnoDuration(CallbackInfoReturnable<Integer> cir) {
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)this.getRepresentingPlayer()).map(vamp -> vamp.getAge()).orElse(0);
        int duration = Math.max(1, (int)((double)((Integer)cir.getReturnValue()).intValue() * (Double)((List)CommonConfig.DBNOTimeMultiplier.get()).get(age)));
        cir.setReturnValue((Object)duration);
    }

    @Redirect(method={"tryResurrect"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;addEffect(Lnet/minecraft/potion/EffectInstance;)Z"))
    private boolean addEffect(PlayerEntity instance, EffectInstance effectInstance) {
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)instance).map(vamp -> vamp.getAge()).orElse(0);
        int duration = Math.max(20, (int)((double)effectInstance.func_76459_b() * (Double)((List)CommonConfig.neonatalTimeMultiplier.get()).get(age)));
        EffectInstance effect = new EffectInstance(effectInstance.func_188419_a(), duration);
        this.player.func_195064_c(effect);
        if ((Integer)CommonConfig.ageLossDBNO.get() > 0) {
            VampiricAgeingCapabilityManager.getAge((LivingEntity)instance).ifPresent(vamp -> vamp.setAge(Math.max(0, age - (Integer)CommonConfig.ageLossDBNO.get())));
        }
        return true;
    }
}

