/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.oils;

import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.vampirism.api.items.oil.IWeaponOil;
import de.teamlapen.vampirism.items.oil.WeaponOil;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SeniorityOil
extends WeaponOil {
    public SeniorityOil(int color, int maxDuration) {
        super(color, maxDuration);
    }

    public float onDamage(ItemStack stack, float amount, IWeaponOil oil, LivingEntity target, LivingEntity source) {
        float bonusDamage = 0.0f;
        if (!Helper.isHunter((Entity)source)) {
            return bonusDamage;
        }
        int sourceAge = VampiricAgeingCapabilityManager.getAge(source).map(ageCap -> ageCap.getAge()).orElse(0);
        if (sourceAge < (Integer)HunterAgeingConfig.seniorityOilUseAge.get()) {
            return bonusDamage;
        }
        if (Helper.isVampire((Entity)target) || CapabilityHelper.isWerewolfCheckMod((Entity)target)) {
            int targetAge = VampiricAgeingCapabilityManager.getAge(target).map(ageCap -> ageCap.getAge()).orElse(0);
            bonusDamage = ((Double)((List)HunterAgeingConfig.seniorityOilDamageBonus.get()).get(targetAge)).floatValue();
            return amount * bonusDamage;
        }
        return bonusDamage;
    }

    public void getDescription(ItemStack stack, List<ITextComponent> tooltips) {
        super.getDescription(stack, tooltips);
        tooltips.add((ITextComponent)new TranslationTextComponent("text.vampiricageing.useable_by", new Object[]{HunterAgeingConfig.seniorityOilUseAge.get()}).func_240699_a_(TextFormatting.DARK_RED));
        tooltips.add((ITextComponent)new TranslationTextComponent("text.vampiricageing.seniority_oil.when_applied").func_240699_a_(TextFormatting.GRAY));
        tooltips.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)new TranslationTextComponent("text.vampiricageing.oil.seniority_oil.more_damage").func_240699_a_(TextFormatting.DARK_GREEN)));
    }
}

