/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.Task;

public class BrainActivityGroup<T extends LivingEntity> {
    private final Activity activity;
    private int priorityStart = 0;
    private final List<Task<? super T>> behaviours = new ObjectArrayList();
    private final Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>> activityStartMemoryConditions = new ObjectOpenHashSet();
    @Nullable
    private Set<MemoryModuleType<?>> wipedMemoriesOnFinish = null;

    public BrainActivityGroup(Activity activity) {
        this.activity = activity;
    }

    public BrainActivityGroup<T> priority(int priorityStart) {
        this.priorityStart = priorityStart;
        return this;
    }

    public BrainActivityGroup<T> behaviours(Task<? super T> ... behaviours) {
        this.behaviours.addAll((Collection<Task<T>>)new ObjectArrayList((Object[])behaviours));
        return this;
    }

    public BrainActivityGroup<T> onlyStartWithMemoryStatus(MemoryModuleType<?> memory, MemoryModuleStatus status) {
        this.activityStartMemoryConditions.add(Pair.of(memory, (Object)status));
        return this;
    }

    public BrainActivityGroup<T> wipeMemoriesWhenFinished(MemoryModuleType<?> ... memories) {
        if (this.wipedMemoriesOnFinish == null) {
            this.wipedMemoriesOnFinish = new ObjectOpenHashSet((Object[])memories);
        } else {
            this.wipedMemoriesOnFinish.addAll((Collection<MemoryModuleType<?>>)new ObjectOpenHashSet((Object[])memories));
        }
        return this;
    }

    public BrainActivityGroup<T> requireAndWipeMemoriesOnUse(MemoryModuleType<?> ... memories) {
        for (MemoryModuleType<?> memory : memories) {
            this.onlyStartWithMemoryStatus(memory, MemoryModuleStatus.VALUE_PRESENT);
        }
        this.wipeMemoriesWhenFinished(memories);
        return this;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public List<Task<? super T>> getBehaviours() {
        return this.behaviours;
    }

    public int getPriorityStart() {
        return this.priorityStart;
    }

    public Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getActivityStartMemoryConditions() {
        return this.activityStartMemoryConditions;
    }

    public Set<MemoryModuleType<?>> getWipedMemoriesOnFinish() {
        return this.wipedMemoriesOnFinish != null ? this.wipedMemoriesOnFinish : new HashSet();
    }

    public ImmutableList<Pair<Integer, Task<? super T>>> pairBehaviourPriorities() {
        int priority = this.priorityStart;
        ImmutableList.Builder pairedBehaviours = ImmutableList.builder();
        for (Task<? super T> task : this.behaviours) {
            pairedBehaviours.add((Object)Pair.of((Object)priority++, task));
        }
        return pairedBehaviours.build();
    }

    public static <T extends LivingEntity> BrainActivityGroup<T> empty() {
        return new BrainActivityGroup<T>(Activity.field_221369_e);
    }

    public static <T extends LivingEntity> BrainActivityGroup<T> coreTasks(Task<? super T> ... behaviours) {
        return new BrainActivityGroup<T>(Activity.field_221365_a).priority(0).behaviours(behaviours);
    }

    public static <T extends LivingEntity> BrainActivityGroup<T> idleTasks(Task<? super T> ... behaviours) {
        return new BrainActivityGroup<T>(Activity.field_221366_b).priority(10).behaviours(behaviours);
    }

    public static <T extends LivingEntity> BrainActivityGroup<T> fightTasks(Task<? super T> ... behaviours) {
        return new BrainActivityGroup<T>(Activity.field_234621_k_).priority(10).behaviours(behaviours).requireAndWipeMemoriesOnUse(MemoryModuleType.field_234103_o_);
    }
}

