/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.Memory;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import org.apache.commons.lang3.mutable.MutableObject;

public class SmartBrain<E extends LivingEntity>
extends Brain<E> {
    private final List<MemoryModuleType<?>> expirableMemories = new ObjectArrayList();
    private final List<ActivityBehaviours<E>> behaviours = new ObjectArrayList();
    private final List<Pair<SensorType<ExtendedSensor<? super E>>, ExtendedSensor<? super E>>> sensors = new ObjectArrayList();
    private boolean sortBehaviours = false;

    public SmartBrain(List<MemoryModuleType<?>> memories, List<? extends ExtendedSensor<E>> sensors, @Nullable List<BrainActivityGroup<E>> taskList, boolean saveMemories) {
        super(memories, (Collection)ImmutableList.of(), ImmutableList.of(), saveMemories ? () -> Brain.func_233710_b_((Collection)memories, SmartBrain.convertSensorsToTypes(sensors)) : SmartBrain::emptyBrainCodec);
        for (ExtendedSensor<E> extendedSensor : sensors) {
            this.sensors.add(Pair.of(extendedSensor.type(), extendedSensor));
        }
        if (taskList != null) {
            for (BrainActivityGroup brainActivityGroup : taskList) {
                this.addActivity(brainActivityGroup);
            }
        }
    }

    public void func_218210_a(ServerWorld level, E entity) {
        ((LivingEntity)entity).field_70170_p.func_217381_Z().func_76320_a("SmartBrain");
        if (this.sortBehaviours) {
            this.behaviours.sort(Comparator.comparingInt(ActivityBehaviours::priority));
        }
        this.func_233721_k_();
        this.tickSensors(level, entity);
        this.checkForNewBehaviours(level, entity);
        this.tickRunningBehaviours(level, entity);
        this.func_233706_a_(((SmartBrainOwner)entity).getActivityPriorities());
        ((LivingEntity)entity).field_70170_p.func_217381_Z().func_76319_b();
        if (entity instanceof MobEntity) {
            ((MobEntity)entity).func_213395_q(BrainUtils.hasMemory(entity, MemoryModuleType.field_234103_o_));
        }
    }

    private void tickSensors(ServerWorld level, E entity) {
        for (Pair<SensorType<ExtendedSensor<? super E>>, ExtendedSensor<? super E>> pair : this.sensors) {
            ((ExtendedSensor)((Object)pair.getSecond())).func_220973_b(level, entity);
        }
    }

    private void checkForNewBehaviours(ServerWorld level, E entity) {
        long gameTime = level.func_82737_E();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : ((ActivityBehaviours)behaviourGroup).behaviours) {
                if (!this.field_218236_g.contains(pair.getFirst())) continue;
                for (Task behaviour : (List)pair.getSecond()) {
                    if (behaviour.func_220376_b() != Task.Status.STOPPED) continue;
                    behaviour.func_220378_b(level, entity, gameTime);
                }
            }
        }
    }

    private void tickRunningBehaviours(ServerWorld level, E entity) {
        long gameTime = level.func_82737_E();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : ((ActivityBehaviours)behaviourGroup).behaviours) {
                for (Task behaviour : (List)pair.getSecond()) {
                    if (behaviour.func_220376_b() != Task.Status.RUNNING) continue;
                    behaviour.func_220377_c(level, entity, gameTime);
                }
            }
        }
    }

    public void func_233721_k_() {
        Iterator<MemoryModuleType<?>> expirable = this.expirableMemories.iterator();
        while (expirable.hasNext()) {
            MemoryModuleType<?> memoryType = expirable.next();
            Optional memory = (Optional)this.field_218230_a.get(memoryType);
            if (!memory.isPresent()) {
                expirable.remove();
                continue;
            }
            Memory value = (Memory)memory.get();
            if (!value.func_234074_e_()) {
                expirable.remove();
                continue;
            }
            if (value.func_234073_d_()) {
                expirable.remove();
                this.func_218189_b(memoryType);
                continue;
            }
            value.func_234064_a_();
        }
    }

    public void func_218227_b(ServerWorld level, E entity) {
        long gameTime = level.func_82737_E();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : ((ActivityBehaviours)behaviourGroup).behaviours) {
                for (Task behaviour : (List)pair.getSecond()) {
                    if (behaviour.func_220376_b() != Task.Status.RUNNING) continue;
                    behaviour.func_220380_e(level, entity, gameTime);
                }
            }
        }
    }

    public <U> Optional<U> func_218207_c(MemoryModuleType<U> type) {
        return this.field_218230_a.computeIfAbsent(type, key -> Optional.empty()).map(Memory::func_234072_c_);
    }

    public <U> void func_233709_b_(MemoryModuleType<U> memoryType, Optional<? extends Memory<?>> memory) {
        Collection collection;
        if (memory.isPresent() && memory.get().func_234072_c_() instanceof Collection && (collection = (Collection)memory.get().func_234072_c_()).isEmpty()) {
            memory = Optional.empty();
        }
        this.field_218230_a.put(memoryType, memory);
        if (memory.isPresent() && memory.get().func_234074_e_()) {
            this.expirableMemories.add(memoryType);
        }
    }

    public <U> boolean func_233708_b_(MemoryModuleType<U> memoryType, U memory) {
        Optional<U> value = this.func_218207_c(memoryType);
        return value.isPresent() && value.get().equals(memory);
    }

    private static <E extends LivingEntity> Codec<Brain<E>> emptyBrainCodec() {
        MutableObject brainCodec = new MutableObject();
        brainCodec.setValue((Object)Codec.unit(() -> new Brain((Collection)ImmutableList.of(), (Collection)ImmutableList.of(), ImmutableList.of(), () -> ((MutableObject)brainCodec).getValue())));
        return (Codec)brainCodec.getValue();
    }

    private static <E extends LivingEntity> List<? extends SensorType<? extends Sensor<? super E>>> convertSensorsToTypes(List<? extends ExtendedSensor<E>> sensors) {
        ObjectArrayList types = new ObjectArrayList(sensors.size());
        for (ExtendedSensor<E> sensor : sensors) {
            types.add(sensor.type());
        }
        return types;
    }

    public Brain<E> func_218185_f() {
        SmartBrain<E> brain = new SmartBrain<E>(this.field_218230_a.keySet().stream().collect(Collectors.toList()), this.sensors.stream().map(pair -> (ExtendedSensor)((Object)((Object)pair.getSecond()))).collect(Collectors.toList()), null, false);
        for (Map.Entry entry : this.field_218230_a.entrySet()) {
            MemoryModuleType memoryType = (MemoryModuleType)entry.getKey();
            if (!((Optional)entry.getValue()).isPresent()) continue;
            brain.field_218230_a.put(memoryType, entry.getValue());
        }
        return brain;
    }

    public List<Task<? super E>> func_233712_d_() {
        ObjectArrayList runningBehaviours = new ObjectArrayList();
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            for (Pair pair : ((ActivityBehaviours)behaviourGroup).behaviours) {
                for (Task behaviour : (List)pair.getSecond()) {
                    if (behaviour.func_220376_b() != Task.Status.RUNNING) continue;
                    runningBehaviours.add(behaviour);
                }
            }
        }
        return runningBehaviours;
    }

    public void removeAllBehaviors() {
        this.behaviours.clear();
    }

    public void func_233701_a_(Activity activity, ImmutableList<? extends Pair<Integer, ? extends Task<? super E>>> tasks, Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>> memorieStatuses, Set<MemoryModuleType<?>> memoryTypes) {
        this.field_218234_e.put(activity, memorieStatuses);
        if (!memoryTypes.isEmpty()) {
            this.field_233691_h_.put(activity, memoryTypes);
        }
        for (Pair pair : tasks) {
            this.addBehaviour((Integer)pair.getFirst(), activity, (Task)pair.getSecond());
        }
    }

    public void addActivity(BrainActivityGroup<E> activityGroup) {
        this.func_233701_a_(activityGroup.getActivity(), activityGroup.pairBehaviourPriorities(), activityGroup.getActivityStartMemoryConditions(), activityGroup.getWipedMemoriesOnFinish());
    }

    public void addBehaviour(int priority, Activity activity, Task<? super E> behaviour) {
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            if (((ActivityBehaviours)behaviourGroup).priority != priority) continue;
            for (Pair pair : ((ActivityBehaviours)behaviourGroup).behaviours) {
                if (pair.getFirst() != activity) continue;
                ((List)pair.getSecond()).add(behaviour);
                return;
            }
            ((ActivityBehaviours)behaviourGroup).behaviours.add(Pair.of((Object)activity, (Object)ObjectArrayList.wrap((Object[])new Task[]{behaviour})));
            return;
        }
        this.behaviours.add(new ActivityBehaviours(priority, ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)activity, (Object)ObjectArrayList.wrap((Object[])new Task[]{behaviour}))})));
        this.sortBehaviours = true;
    }

    public void removeBehaviour(int priority, Activity activity, Task<? super E> behaviour) {
        for (ActivityBehaviours<E> behaviourGroup : this.behaviours) {
            if (((ActivityBehaviours)behaviourGroup).priority != priority) continue;
            for (Pair pair : ((ActivityBehaviours)behaviourGroup).behaviours) {
                if (pair.getFirst() != activity) continue;
                Iterator iterator = ((List)pair.getSecond()).iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != behaviour) continue;
                    iterator.remove();
                    return;
                }
                return;
            }
            return;
        }
    }

    private class ActivityBehaviours<T extends LivingEntity> {
        private int priority;
        private List<Pair<Activity, List<Task<? super T>>>> behaviours;

        public int priority() {
            return this.priority;
        }

        public List<Pair<Activity, List<Task<? super T>>>> behaviours() {
            return this.behaviours;
        }

        public ActivityBehaviours(int priority, List<Pair<Activity, List<Task<? super T>>>> behaviours) {
            this.priority = priority;
            this.behaviours = behaviours;
        }
    }
}

