/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.MultiTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraftforge.fml.loading.FMLLoader;
import net.tslat.smartbrainlib.SmartBrainLib;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrain;
import net.tslat.smartbrainlib.api.core.behaviour.GroupBehaviour;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import org.apache.logging.log4j.Level;

public class SmartBrainProvider<E extends LivingEntity>
extends Brain.BrainCodec<E> {
    private static final Map<EntityType<? extends LivingEntity>, ImmutableList<MemoryModuleType<?>>> BRAIN_MEMORY_CACHE = new Object2ObjectOpenHashMap();
    private final E owner;
    private final boolean saveMemories;
    private final boolean nonStaticMemories;

    public SmartBrainProvider(E owner) {
        this(owner, false);
    }

    public SmartBrainProvider(E owner, boolean nonStaticMemories) {
        this(owner, false, nonStaticMemories);
    }

    public SmartBrainProvider(E owner, boolean saveMemories, boolean nonStaticMemories) {
        super(new ArrayList(), new ArrayList());
        this.owner = owner;
        this.saveMemories = saveMemories;
        this.nonStaticMemories = nonStaticMemories;
    }

    @Nullable
    public final SmartBrain<E> makeBrain(Dynamic<?> codecLoader) {
        Object memories;
        if (((LivingEntity)this.owner).field_70170_p.func_201670_d()) {
            return null;
        }
        List sensors = ((SmartBrainOwner)this.owner).getSensors();
        List<BrainActivityGroup<E>> taskList = this.compileTasks();
        if (!this.nonStaticMemories && BRAIN_MEMORY_CACHE.containsKey(this.owner.func_200600_R())) {
            memories = BRAIN_MEMORY_CACHE.get(this.owner.func_200600_R());
        } else {
            memories = this.createMemoryList(taskList, sensors);
            if (!this.nonStaticMemories) {
                BRAIN_MEMORY_CACHE.put((EntityType<LivingEntity>)((EntityType<? extends LivingEntity>)this.owner.func_200600_R()), (ImmutableList<MemoryModuleType<?>>)memories);
            }
        }
        SmartBrain brain = new SmartBrain((List<MemoryModuleType<?>>)memories, sensors, taskList, this.saveMemories);
        this.finaliseBrain(brain);
        this.sanityCheckBrainState(brain);
        return brain;
    }

    private ImmutableList<MemoryModuleType<?>> createMemoryList(List<BrainActivityGroup<E>> taskList, List<? extends ExtendedSensor<?>> sensors) {
        ObjectOpenHashSet memoryTypes = new ObjectOpenHashSet();
        taskList.forEach(arg_0 -> this.lambda$createMemoryList$1((Set)memoryTypes, arg_0));
        sensors.forEach(arg_0 -> SmartBrainProvider.lambda$createMemoryList$2((Set)memoryTypes, arg_0));
        return ImmutableList.copyOf((Collection)memoryTypes);
    }

    private void collectMemoriesFromTask(Set<MemoryModuleType<?>> memories, Task<?> behaviour) {
        if (behaviour instanceof MultiTask) {
            ((MultiTask)behaviour).field_220419_e.func_220655_b().forEach(subBehaviour -> this.collectMemoriesFromTask(memories, (Task)subBehaviour));
        } else if (behaviour instanceof GroupBehaviour) {
            ((GroupBehaviour)behaviour).getBehaviours().forEachRemaining(subBehaviour -> this.collectMemoriesFromTask(memories, (Task<?>)subBehaviour));
        } else {
            memories.addAll(behaviour.field_223010_a.keySet());
        }
    }

    private List<BrainActivityGroup<E>> compileTasks() {
        ObjectArrayList tasks = new ObjectArrayList();
        BrainActivityGroup activityGroup = ((SmartBrainOwner)this.owner).getCoreTasks();
        if (!activityGroup.getBehaviours().isEmpty()) {
            tasks.add(activityGroup);
        }
        if (!(activityGroup = ((SmartBrainOwner)this.owner).getIdleTasks()).getBehaviours().isEmpty()) {
            tasks.add(activityGroup);
        }
        if (!(activityGroup = ((SmartBrainOwner)this.owner).getFightTasks()).getBehaviours().isEmpty()) {
            tasks.add(activityGroup);
        }
        tasks.addAll(((SmartBrainOwner)this.owner).getAdditionalTasks().values());
        return tasks;
    }

    private void finaliseBrain(SmartBrain<E> brain) {
        brain.func_218199_a(((SmartBrainOwner)this.owner).getAlwaysRunningActivities());
        brain.func_218200_b(((SmartBrainOwner)this.owner).getDefaultActivity());
        brain.func_233714_e_();
        ((SmartBrainOwner)this.owner).handleAdditionalBrainSetup(brain);
    }

    private void sanityCheckBrainState(SmartBrain<E> brain) {
        if (!FMLLoader.isProduction()) {
            SmartBrainLib.LOGGER.log(Level.INFO, "SmartBrainLib checking brain state for " + this.owner.toString() + ". This will only occur while in debug mode");
            for (Activity activity : brain.field_218235_f) {
                if (brain.field_218234_e.containsKey(activity)) continue;
                SmartBrainLib.LOGGER.log(Level.WARN, "Entity " + this.owner.toString() + " has " + activity.toString() + " listed as a core activity, but no behaviours for this activity have been registered.");
            }
        }
    }

    protected void addActivity(SmartBrain<E> brain, Activity activity, BrainActivityGroup<E> activityGroup) {
        brain.field_218234_e.put(activity, activityGroup.getActivityStartMemoryConditions());
        if (!activityGroup.getWipedMemoriesOnFinish().isEmpty()) {
            brain.field_233691_h_.put(activity, activityGroup.getWipedMemoriesOnFinish());
        }
        for (Pair pair : activityGroup.pairBehaviourPriorities()) {
            brain.addBehaviour((Integer)pair.getFirst(), activity, (Task)pair.getSecond());
        }
    }

    private static /* synthetic */ void lambda$createMemoryList$2(Set memoryTypes, ExtendedSensor sensor) {
        memoryTypes.addAll(sensor.memoriesUsed());
    }

    private /* synthetic */ void lambda$createMemoryList$1(Set memoryTypes, BrainActivityGroup activityGroup) {
        activityGroup.getBehaviours().forEach(behavior -> this.collectMemoriesFromTask(memoryTypes, (Task<?>)behavior));
    }
}

