/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour;

import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;

public abstract class DelayedBehaviour<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    protected final int delayTime;
    protected long delayFinishedAt = 0L;
    protected Consumer<E> delayedCallback = entity -> {};

    public DelayedBehaviour(int delayTicks) {
        this.delayTime = delayTicks;
        this.runFor(entity -> Math.max(delayTicks, 60));
    }

    public final DelayedBehaviour<E> whenActivating(Consumer<E> callback) {
        this.delayedCallback = callback;
        return this;
    }

    @Override
    protected final void func_212831_a_(ServerWorld level, E entity, long gameTime) {
        if (this.delayTime > 0) {
            this.delayFinishedAt = gameTime + (long)this.delayTime;
            super.func_212831_a_(level, entity, gameTime);
        } else {
            super.func_212831_a_(level, entity, gameTime);
            this.doDelayedAction(entity);
        }
    }

    @Override
    protected final void func_212835_f_(ServerWorld level, E entity, long gameTime) {
        super.func_212835_f_(level, entity, gameTime);
        this.delayFinishedAt = 0L;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return this.delayFinishedAt >= ((LivingEntity)entity).field_70170_p.func_82737_E();
    }

    @Override
    protected final void func_212833_d_(ServerWorld level, E entity, long gameTime) {
        super.func_212833_d_(level, entity, gameTime);
        if (this.delayFinishedAt <= gameTime) {
            this.doDelayedAction(entity);
            this.delayedCallback.accept(entity);
        }
    }

    protected void doDelayedAction(E entity) {
    }
}

