/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.world.server.ServerWorld;

public abstract class ExtendedBehaviour<E extends LivingEntity>
extends Task<E> {
    protected Predicate<E> startCondition = entity -> true;
    protected Predicate<E> stopCondition = entity -> true;
    protected Consumer<E> taskStartCallback = entity -> {};
    protected Consumer<E> taskStopCallback = entity -> {};
    protected Function<E, Integer> runtimeProvider = entity -> 60;
    protected Function<E, Integer> cooldownProvider = entity -> 0;
    protected long cooldownFinishedAt = 0L;

    public ExtendedBehaviour() {
        super((Map)new Object2ObjectOpenHashMap());
        for (Pair<MemoryModuleType<?>, MemoryModuleStatus> memoryReq : this.getMemoryRequirements()) {
            this.field_223010_a.put(memoryReq.getFirst(), memoryReq.getSecond());
        }
    }

    public final ExtendedBehaviour<E> whenStarting(Consumer<E> callback) {
        this.taskStartCallback = callback;
        return this;
    }

    public final ExtendedBehaviour<E> whenStopping(Consumer<E> callback) {
        this.taskStopCallback = callback;
        return this;
    }

    public final ExtendedBehaviour<E> runFor(Function<E, Integer> timeProvider) {
        this.runtimeProvider = timeProvider;
        return this;
    }

    public final ExtendedBehaviour<E> cooldownFor(Function<E, Integer> timeProvider) {
        this.cooldownProvider = timeProvider;
        return this;
    }

    public final ExtendedBehaviour<E> startCondition(Predicate<E> predicate) {
        this.startCondition = predicate;
        return this;
    }

    public final ExtendedBehaviour<E> stopIf(Predicate<E> predicate) {
        this.stopCondition = predicate;
        return this;
    }

    public final boolean func_220378_b(ServerWorld level, E entity, long gameTime) {
        if (!this.doStartCheck(level, entity, gameTime)) {
            return false;
        }
        this.field_220384_a = Task.Status.RUNNING;
        this.field_220385_b = gameTime + (long)this.runtimeProvider.apply(entity).intValue();
        this.func_212831_a_(level, entity, gameTime);
        return true;
    }

    protected boolean doStartCheck(ServerWorld level, E entity, long gameTime) {
        return this.cooldownFinishedAt <= gameTime && this.func_220382_a(entity) && this.startCondition.test(entity) && this.func_212832_a_(level, entity);
    }

    protected boolean func_212832_a_(ServerWorld level, E entity) {
        return true;
    }

    protected void func_212831_a_(ServerWorld level, E entity, long gameTime) {
        this.taskStartCallback.accept(entity);
        this.start(entity);
    }

    protected void start(E entity) {
    }

    protected void func_212835_f_(ServerWorld level, E entity, long gameTime) {
        this.cooldownFinishedAt = gameTime + (long)this.cooldownProvider.apply(entity).intValue();
        this.taskStopCallback.accept(entity);
        this.stop(entity);
    }

    protected void stop(E entity) {
    }

    protected boolean func_212834_g_(ServerWorld level, E entity, long gameTime) {
        return this.shouldKeepRunning(entity) && this.stopCondition.test(entity);
    }

    protected boolean shouldKeepRunning(E entity) {
        return false;
    }

    protected void func_212833_d_(ServerWorld level, E entity, long gameTime) {
        this.tick(entity);
    }

    protected void tick(E entity) {
    }

    protected boolean func_220383_a(long gameTime) {
        return super.func_220383_a(gameTime);
    }

    public final boolean func_220382_a(E entity) {
        Brain brain = entity.func_213375_cj();
        for (Pair<MemoryModuleType<?>, MemoryModuleStatus> memoryPair : this.getMemoryRequirements()) {
            if (brain.func_218196_a((MemoryModuleType)memoryPair.getFirst(), (MemoryModuleStatus)memoryPair.getSecond())) continue;
            return false;
        }
        return true;
    }

    protected abstract List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements();
}

