/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.SBLShufflingList;

public abstract class GroupBehaviour<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private final SBLShufflingList<ExtendedBehaviour<? super E>> behaviours;
    @Nullable
    private ExtendedBehaviour<? super E> runningBehaviour = null;

    public GroupBehaviour(Pair<ExtendedBehaviour<? super E>, Integer> ... behaviours) {
        this.behaviours = new SBLShufflingList<ExtendedBehaviour<E>>(behaviours);
    }

    public GroupBehaviour(ExtendedBehaviour<? super E> ... behaviours) {
        this.behaviours = new SBLShufflingList();
        for (ExtendedBehaviour<? super E> behaviour : behaviours) {
            this.behaviours.add(behaviour, 1);
        }
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return new ArrayList();
    }

    public Iterator<ExtendedBehaviour<? super E>> getBehaviours() {
        return this.behaviours.iterator();
    }

    @Nullable
    protected abstract ExtendedBehaviour<? super E> pickBehaviour(ServerWorld var1, E var2, long var3, SBLShufflingList<ExtendedBehaviour<? super E>> var5);

    @Override
    protected boolean doStartCheck(ServerWorld level, E entity, long gameTime) {
        if (!super.doStartCheck(level, entity, gameTime)) {
            return false;
        }
        this.runningBehaviour = this.pickBehaviour(level, entity, gameTime, this.behaviours);
        return this.runningBehaviour != null;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return this.runningBehaviour != null && this.runningBehaviour.func_212834_g_((ServerWorld)((LivingEntity)entity).field_70170_p, entity, ((LivingEntity)entity).field_70170_p.func_82737_E());
    }

    @Override
    protected boolean func_220383_a(long gameTime) {
        return this.runningBehaviour == null || this.runningBehaviour.func_220383_a(gameTime);
    }

    @Override
    protected void func_212833_d_(ServerWorld level, E owner, long gameTime) {
        this.runningBehaviour.func_220377_c(level, (LivingEntity)owner, gameTime);
        if (this.runningBehaviour.func_220376_b() == Task.Status.STOPPED) {
            this.runningBehaviour = null;
            this.func_220380_e(level, (LivingEntity)owner, gameTime);
        }
    }

    @Override
    protected void func_212835_f_(ServerWorld level, E entity, long gameTime) {
        super.func_212835_f_(level, entity, gameTime);
        if (this.runningBehaviour != null) {
            this.runningBehaviour.func_212835_f_(level, entity, gameTime);
        }
        this.runningBehaviour = null;
    }

    public Task.Status func_220376_b() {
        if (this.runningBehaviour == null) {
            return Task.Status.STOPPED;
        }
        return this.runningBehaviour.func_220376_b();
    }
}

