/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.attack;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.DelayedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;

public class AnimatableMeleeAttack<E extends MobEntity>
extends DelayedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{new Pair((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT), new Pair((Object)MemoryModuleType.field_234104_p_, (Object)MemoryModuleStatus.VALUE_ABSENT)});
    private Function<E, Integer> attackIntervalSupplier = entity -> 20;
    @Nullable
    protected LivingEntity target = null;

    public AnimatableMeleeAttack(int delayTicks) {
        super(delayTicks);
    }

    public AnimatableMeleeAttack<E> attackInterval(Function<E, Integer> supplier) {
        this.attackIntervalSupplier = supplier;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerWorld level, E entity) {
        this.target = BrainUtils.getTargetOfEntity(entity);
        return entity.func_70635_at().func_75522_a((Entity)this.target) && BrainUtil.func_233874_b_(entity, (LivingEntity)this.target);
    }

    @Override
    protected void start(E entity) {
        entity.func_184609_a(Hand.MAIN_HAND);
        BrainUtils.lookAtEntity(entity, this.target);
    }

    @Override
    protected void stop(E entity) {
        this.target = null;
    }

    @Override
    protected void doDelayedAction(E entity) {
        BrainUtils.setForgettableMemory(entity, MemoryModuleType.field_234104_p_, Boolean.valueOf(true), (int)this.attackIntervalSupplier.apply(entity));
        if (this.target == null) {
            return;
        }
        if (!entity.func_70635_at().func_75522_a((Entity)this.target) || !BrainUtil.func_233874_b_(entity, (LivingEntity)this.target)) {
            return;
        }
        entity.func_70652_k((Entity)this.target);
    }
}

