/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.attack;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.util.Hand;
import net.minecraft.world.Difficulty;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.DelayedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;

public class AnimatableRangedAttack<E extends LivingEntity>
extends DelayedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.field_234104_p_, (Object)MemoryModuleStatus.VALUE_ABSENT)});
    protected Function<E, Integer> attackIntervalSupplier = entity -> entity.field_70170_p.func_175659_aa() == Difficulty.HARD ? 20 : 40;
    protected float attackRadius;
    @Nullable
    protected LivingEntity target = null;

    public AnimatableRangedAttack(int delayTicks) {
        super(delayTicks);
        this.attackRadius(16.0f);
    }

    public AnimatableRangedAttack<E> attackInterval(Function<E, Integer> supplier) {
        this.attackIntervalSupplier = supplier;
        return this;
    }

    public AnimatableRangedAttack<E> attackRadius(float radius) {
        this.attackRadius = radius * radius;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean func_212832_a_(ServerWorld level, E entity) {
        this.target = BrainUtils.getTargetOfEntity(entity);
        return BrainUtils.canSee(entity, this.target) && entity.func_70068_e((Entity)this.target) <= (double)this.attackRadius;
    }

    @Override
    protected void start(E entity) {
        entity.func_184609_a(Hand.MAIN_HAND);
        BrainUtils.lookAtEntity(entity, this.target);
    }

    @Override
    protected void stop(E entity) {
        this.target = null;
    }

    @Override
    protected void doDelayedAction(E entity) {
        if (this.target == null) {
            return;
        }
        if (!BrainUtils.canSee(entity, this.target) || entity.func_70068_e((Entity)this.target) > (double)this.attackRadius) {
            return;
        }
        ((IRangedAttackMob)entity).func_82196_d(this.target, 1.0f);
        BrainUtils.setForgettableMemory(entity, MemoryModuleType.field_234104_p_, Boolean.valueOf(true), (int)this.attackIntervalSupplier.apply(entity));
    }
}

