/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.attack;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.DelayedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;

public class ConditionlessAttack<E extends LivingEntity>
extends DelayedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_234104_p_, (Object)MemoryModuleStatus.VALUE_ABSENT)});
    protected Function<E, Integer> attackIntervalSupplier = entity -> 20;
    protected boolean requireTarget = false;
    protected Consumer<E> effect = entity -> {};
    @Nullable
    protected LivingEntity target = null;

    public ConditionlessAttack(int delayTicks) {
        super(delayTicks);
    }

    public ConditionlessAttack<E> attackInterval(Function<E, Integer> supplier) {
        this.attackIntervalSupplier = supplier;
        return this;
    }

    public ConditionlessAttack<E> requiresTarget() {
        this.requireTarget = true;
        return this;
    }

    public ConditionlessAttack<E> attack(Consumer<E> consumer) {
        this.effect = consumer;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean func_212832_a_(ServerWorld level, E entity) {
        if (!this.requireTarget) {
            return true;
        }
        this.target = BrainUtils.getTargetOfEntity(entity);
        return this.target != null;
    }

    @Override
    protected void start(E entity) {
        entity.func_184609_a(Hand.MAIN_HAND);
        if (this.requireTarget) {
            BrainUtils.lookAtEntity(entity, this.target);
        }
    }

    @Override
    protected void doDelayedAction(E entity) {
        if (this.requireTarget && this.target == null) {
            return;
        }
        this.effect.accept(entity);
        BrainUtils.setForgettableMemory(entity, MemoryModuleType.field_234104_p_, Boolean.valueOf(true), (int)this.attackIntervalSupplier.apply(entity));
    }
}

