/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.misc;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.api.util.TriFunction;
import net.tslat.smartbrainlib.object.TriPredicate;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;

public class BreakBlock<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)SBLMemoryTypes.NEARBY_BLOCKS.get(), (Object)MemoryModuleStatus.VALUE_PRESENT)});
    protected TriPredicate<E, BlockPos, BlockState> targetBlockPredicate = (entity, pos, state) -> state.func_235714_a_((ITag)BlockTags.field_200029_f);
    protected TriPredicate<E, BlockPos, BlockState> stopPredicate = (entity, pos, state) -> false;
    protected TriFunction<E, BlockPos, BlockState, Integer> digTimePredicate = (entity, pos, state) -> 240;
    protected BlockPos pos = null;
    protected BlockState state = null;
    protected int timeToBreak = 0;
    protected int breakTime = 0;
    protected int breakProgress = -1;

    public BreakBlock<E> stopBreakingIf(TriPredicate<E, BlockPos, BlockState> predicate) {
        this.stopPredicate = predicate;
        return this;
    }

    public BreakBlock<E> forBlocks(TriPredicate<E, BlockPos, BlockState> predicate) {
        this.targetBlockPredicate = predicate;
        return this;
    }

    public BreakBlock<E> timeToBreak(TriFunction<E, BlockPos, BlockState, Integer> function) {
        this.digTimePredicate = function;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean func_220383_a(long gameTime) {
        return this.breakProgress < 0 && super.func_220383_a(gameTime);
    }

    @Override
    protected void stop(E entity) {
        ((LivingEntity)entity).field_70170_p.func_175715_c(entity.func_145782_y(), this.pos, -1);
        this.state = null;
        this.pos = null;
        this.timeToBreak = 0;
        this.breakTime = 0;
        this.breakProgress = -1;
    }

    @Override
    protected boolean func_212832_a_(ServerWorld level, E entity) {
        for (Pair pair : (List)BrainUtils.getMemory(entity, (MemoryModuleType)SBLMemoryTypes.NEARBY_BLOCKS.get())) {
            if (!this.targetBlockPredicate.test(entity, (BlockPos)pair.getFirst(), (BlockState)pair.getSecond()) || !ForgeHooks.canEntityDestroy((World)level, (BlockPos)((BlockPos)pair.getFirst()), entity)) continue;
            this.pos = (BlockPos)pair.getFirst();
            this.state = (BlockState)pair.getSecond();
            this.timeToBreak = this.digTimePredicate.apply(entity, this.pos, this.state);
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return ((LivingEntity)entity).field_70170_p.func_82737_E() <= (long)this.breakTime && this.targetBlockPredicate.test(entity, this.pos, ((LivingEntity)entity).field_70170_p.func_180495_p(this.pos)) && !this.stopPredicate.test(entity, this.pos, this.state);
    }

    @Override
    protected void tick(E entity) {
        ++this.breakTime;
        int progress = (int)((float)this.breakTime / (float)this.timeToBreak * 10.0f);
        if (progress != this.breakProgress) {
            ((LivingEntity)entity).field_70170_p.func_175715_c(entity.func_145782_y(), this.pos, progress);
            this.breakProgress = progress;
        }
        if (this.breakTime >= this.timeToBreak) {
            ((LivingEntity)entity).field_70170_p.func_217377_a(this.pos, false);
            ((LivingEntity)entity).field_70170_p.func_217379_c(2001, this.pos, Block.func_196246_j((BlockState)((LivingEntity)entity).field_70170_p.func_180495_p(this.pos)));
            this.func_220380_e((ServerWorld)((LivingEntity)entity).field_70170_p, (LivingEntity)entity, ((LivingEntity)entity).field_70170_p.func_82737_E());
        }
    }
}

