/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.misc;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;

public class ReactToUnreachableTarget<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_223021_x, (Object)MemoryModuleStatus.VALUE_PRESENT), Pair.of((Object)SBLMemoryTypes.TARGET_UNREACHABLE.get(), (Object)MemoryModuleStatus.VALUE_PRESENT)});
    protected Function<E, Integer> ticksToReact = entity -> 100;
    protected BiConsumer<E, Boolean> callback = (entity, towering) -> {};
    protected long reactAtTime = 0L;

    public ReactToUnreachableTarget<E> timeBeforeReacting(Function<E, Integer> ticksToReact) {
        this.ticksToReact = ticksToReact;
        return this;
    }

    public ReactToUnreachableTarget<E> reaction(BiConsumer<E, Boolean> callback) {
        this.callback = callback;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean func_220383_a(long gameTime) {
        return this.reactAtTime == 0L || this.reactAtTime < gameTime;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return this.func_220382_a(entity);
    }

    @Override
    protected void start(E entity) {
        this.reactAtTime = ((LivingEntity)entity).field_70170_p.func_82737_E() + (long)this.ticksToReact.apply(entity).intValue();
    }

    @Override
    protected void stop(E entity) {
        this.reactAtTime = 0L;
    }

    @Override
    protected void tick(E entity) {
        if (((LivingEntity)entity).field_70170_p.func_82737_E() == this.reactAtTime) {
            this.callback.accept(entity, (Boolean)BrainUtils.getMemory(entity, (MemoryModuleType)SBLMemoryTypes.TARGET_UNREACHABLE.get()));
        }
    }
}

