/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.object.NearestVisibleLivingEntities;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;

public class AvoidEntity<E extends CreatureEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)SBLMemoryTypes.NEAREST_VISIBLE_LIVING_ENTITIES.get(), (Object)MemoryModuleStatus.VALUE_PRESENT)});
    protected Predicate<LivingEntity> avoidingPredicate = target -> false;
    protected float noCloserThanSqr = 9.0f;
    protected float stopAvoidingAfterSqr = 49.0f;
    protected BiFunction<E, Vector3d, Float> speedModifier = (entity, targetPos) -> Float.valueOf(1.0f);
    protected Path runPath = null;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public AvoidEntity<E> noCloserThan(float blocks) {
        this.noCloserThanSqr = blocks * blocks;
        return this;
    }

    public AvoidEntity<E> stopCaringAfter(float blocks) {
        this.stopAvoidingAfterSqr = blocks * blocks;
        return this;
    }

    public AvoidEntity<E> avoiding(Predicate<LivingEntity> predicate) {
        this.avoidingPredicate = predicate;
        return this;
    }

    public AvoidEntity<E> speedModifier(float modifier) {
        return this.speedModifier((entity, targetPos) -> Float.valueOf(modifier));
    }

    public AvoidEntity<E> speedModifier(BiFunction<E, Vector3d, Float> function) {
        this.speedModifier = function;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerWorld level, E entity) {
        Optional<LivingEntity> target = ((NearestVisibleLivingEntities)BrainUtils.getMemory(entity, (MemoryModuleType)SBLMemoryTypes.NEAREST_VISIBLE_LIVING_ENTITIES.get())).findFirstMatchingEntry(this.avoidingPredicate);
        if (!target.isPresent()) {
            return false;
        }
        LivingEntity avoidingEntity = target.get();
        double distToTarget = avoidingEntity.func_70068_e(entity);
        if (distToTarget > (double)this.noCloserThanSqr) {
            return false;
        }
        Vector3d runPos = RandomPositionGenerator.func_75461_b(entity, (int)16, (int)7, (Vector3d)avoidingEntity.func_213303_ch());
        if (runPos == null || avoidingEntity.func_70092_e(runPos.field_72450_a, runPos.field_72448_b, runPos.field_72449_c) < distToTarget) {
            return false;
        }
        this.runPath = entity.func_70661_as().func_225466_a(runPos.field_72450_a, runPos.field_72448_b, runPos.field_72449_c, 0);
        return this.runPath != null;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return !this.runPath.func_75879_b();
    }

    @Override
    protected boolean func_220383_a(long gameTime) {
        return false;
    }

    @Override
    protected void start(E entity) {
        entity.func_70661_as().func_75484_a(this.runPath, (double)this.speedModifier.apply(entity, this.runPath.func_75881_a(entity, this.runPath.func_75874_d() - 1)).floatValue());
    }

    @Override
    protected void stop(E entity) {
        this.runPath = null;
        entity.func_70661_as().func_75489_a(1.0);
    }
}

