/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;

public class EscapeSun<E extends CreatureEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.REGISTERED)});
    protected BiFunction<E, Vector3d, Float> speedModifier = (entity, targetPos) -> Float.valueOf(1.0f);
    protected Vector3d hidePos = null;

    public EscapeSun<E> speedModifier(float modifier) {
        return this.speedModifier((entity, targetPos) -> Float.valueOf(modifier));
    }

    public EscapeSun<E> speedModifier(BiFunction<E, Vector3d, Float> function) {
        this.speedModifier = function;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerWorld level, E entity) {
        if (!(level.func_72935_r() && entity.func_70027_ad() && level.func_226660_f_(entity.func_233580_cy_()))) {
            return false;
        }
        if (!entity.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
            return false;
        }
        this.hidePos = this.getHidePos(entity);
        return this.hidePos != null;
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setMemory(entity, MemoryModuleType.field_220950_k, new WalkTarget(this.hidePos, this.speedModifier.apply(entity, this.hidePos).floatValue(), 0));
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        if (this.hidePos == null) {
            return false;
        }
        WalkTarget walkTarget = (WalkTarget)BrainUtils.getMemory(entity, MemoryModuleType.field_220950_k);
        if (walkTarget == null) {
            return false;
        }
        return walkTarget.func_220966_a().func_220608_a().equals((Object)new BlockPos(this.hidePos)) && !entity.func_70661_as().func_75500_f();
    }

    @Override
    protected boolean func_220383_a(long gameTime) {
        return false;
    }

    @Override
    protected void stop(E entity) {
        this.hidePos = null;
    }

    @Nullable
    protected Vector3d getHidePos(E entity) {
        Random randomsource = entity.func_70681_au();
        BlockPos entityPos = entity.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            BlockPos hidePos = entityPos.func_177982_a(randomsource.nextInt(20) - 10, randomsource.nextInt(6) - 3, randomsource.nextInt(20) - 10);
            if (((CreatureEntity)entity).field_70170_p.func_226660_f_(hidePos) || !(entity.func_180484_a(hidePos) < 0.0f)) continue;
            return Vector3d.func_237492_c_((Vector3i)hidePos);
        }
        return null;
    }
}

