/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;

public class FleeTarget<E extends CreatureEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT)});
    protected BiFunction<E, LivingEntity, Integer> fleeDistance = (entity, target) -> 20;
    protected BiFunction<E, Vector3d, Float> speedModifier = (entity, targetPos) -> Float.valueOf(1.0f);
    protected Path runPath = null;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public FleeTarget<E> fleeDistance(int blocks) {
        return this.fleeDistance((entity, target) -> blocks);
    }

    public FleeTarget<E> fleeDistance(BiFunction<E, LivingEntity, Integer> function) {
        this.fleeDistance = function;
        return this;
    }

    public FleeTarget<E> speedModifier(float modifier) {
        return this.speedModifier((entity, targetPos) -> Float.valueOf(modifier));
    }

    public FleeTarget<E> speedModifier(BiFunction<E, Vector3d, Float> function) {
        this.speedModifier = function;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerWorld level, E entity) {
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        double distToTarget = entity.func_70068_e((Entity)target);
        Vector3d runPos = RandomPositionGenerator.func_75461_b(entity, (int)this.fleeDistance.apply(entity, target), (int)10, (Vector3d)target.func_213303_ch());
        if (runPos == null || target.func_70092_e(runPos.field_72450_a, runPos.field_72448_b, runPos.field_72449_c) < distToTarget) {
            return false;
        }
        this.runPath = entity.func_70661_as().func_225466_a(runPos.field_72450_a, runPos.field_72448_b, runPos.field_72449_c, 0);
        return this.runPath != null;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return entity.func_70661_as().func_75505_d() == this.runPath && !entity.func_70661_as().func_75500_f();
    }

    @Override
    protected boolean func_220383_a(long gameTime) {
        return false;
    }

    @Override
    protected void start(E entity) {
        entity.func_70661_as().func_75484_a(this.runPath, (double)this.speedModifier.apply(entity, this.runPath.func_75881_a(entity, this.runPath.func_75874_d() - 1)).floatValue());
        BrainUtils.clearMemory(entity, MemoryModuleType.field_234103_o_);
    }

    @Override
    protected void stop(E entity) {
        if (entity.func_70661_as().func_75505_d() == this.runPath) {
            entity.func_70661_as().func_75489_a(1.0);
        }
        this.runPath = null;
    }
}

