/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.api.util.RandomUtil;

public class FollowEntity<E extends CreatureEntity, T extends Entity>
extends ExtendedBehaviour<E> {
    protected Function<E, T> followingEntityProvider = entity -> null;
    protected BiFunction<E, T, Double> teleportDistance = (entity, target) -> Double.MAX_VALUE;
    protected BiFunction<E, T, Double> followDistMin = (entity, target) -> 4.0;
    protected BiFunction<E, T, Float> speedMod = (entity, target) -> Float.valueOf(1.0f);
    protected float oldWaterPathMalus = 0.0f;
    protected float oldLavaPathMalus = 0.0f;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return new ArrayList();
    }

    public FollowEntity<E, T> following(Function<E, T> following) {
        this.followingEntityProvider = following;
        return this;
    }

    public FollowEntity<E, T> teleportToTargetAfter(double distance) {
        return this.teleportToTargetAfter((entity, target) -> distance);
    }

    public FollowEntity<E, T> teleportToTargetAfter(BiFunction<E, T, Double> distanceProvider) {
        this.teleportDistance = distanceProvider;
        return this;
    }

    public FollowEntity<E, T> stopFollowingWithin(double distance) {
        return this.stopFollowingWithin((entity, target) -> distance);
    }

    public FollowEntity<E, T> stopFollowingWithin(BiFunction<E, T, Double> distanceProvider) {
        this.followDistMin = distanceProvider;
        return this;
    }

    public FollowEntity<E, T> speedMod(float modifier) {
        return this.speedMod((entity, target) -> Float.valueOf(modifier));
    }

    public FollowEntity<E, T> speedMod(BiFunction<E, T, Float> modifier) {
        this.speedMod = modifier;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerWorld level, E entity) {
        Entity target = (Entity)this.followingEntityProvider.apply(entity);
        if (target == null || target.func_175149_v()) {
            return false;
        }
        double minDist = this.followDistMin.apply(entity, target);
        return entity.func_70068_e(target) > minDist * minDist;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        double minDist;
        if (entity.func_70661_as().func_75500_f()) {
            return false;
        }
        Entity target = (Entity)this.followingEntityProvider.apply(entity);
        if (target == null) {
            return false;
        }
        double dist = entity.func_70068_e(target);
        return dist > (minDist = this.followDistMin.apply(entity, target).doubleValue()) * minDist;
    }

    @Override
    protected void start(E entity) {
        Entity target = (Entity)this.followingEntityProvider.apply(entity);
        double minDist = this.followDistMin.apply(entity, target);
        float speedMod = this.speedMod.apply(entity, target).floatValue();
        this.oldWaterPathMalus = entity.func_184643_a(PathNodeType.WATER);
        if (entity.func_230279_az_()) {
            this.oldLavaPathMalus = entity.func_184643_a(PathNodeType.LAVA);
            entity.func_184644_a(PathNodeType.LAVA, 0.0f);
        }
        BrainUtils.setMemory(entity, MemoryModuleType.field_220950_k, new WalkTarget(target.func_213303_ch(), speedMod, (int)minDist));
        BrainUtils.setMemory(entity, MemoryModuleType.field_220951_l, new EntityPosWrapper(target, true));
        entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    @Override
    protected void stop(E entity) {
        entity.func_184644_a(PathNodeType.WATER, this.oldWaterPathMalus);
        if (entity.func_230279_az_()) {
            entity.func_184644_a(PathNodeType.LAVA, this.oldLavaPathMalus);
        }
        entity.func_70661_as().func_75499_g();
        BrainUtils.clearMemory(entity, MemoryModuleType.field_220950_k);
    }

    @Override
    protected void tick(E entity) {
        Entity target = (Entity)this.followingEntityProvider.apply(entity);
        double teleportDist = this.teleportDistance.apply(entity, target);
        if (entity.func_70068_e(target) >= teleportDist * teleportDist) {
            this.teleportToTarget(entity, target);
        }
    }

    protected void teleportToTarget(E entity, T target) {
        World level = ((CreatureEntity)entity).field_70170_p;
        BlockPos entityPos = target.func_233580_cy_();
        BlockPos pos = RandomUtil.getRandomPositionWithinRange(entityPos, 5, 5, 5, 1, 1, 1, true, level, 10, (state, statePos) -> {
            PathNodeType pathTypes = entity.func_70661_as().func_189566_q().func_186330_a((IBlockReader)level, statePos.func_177958_n(), statePos.func_177956_o(), statePos.func_177952_p());
            if (pathTypes != PathNodeType.WALKABLE) {
                return false;
            }
            return level.func_226665_a__((Entity)entity, entity.func_174813_aQ().func_186670_a(statePos.func_177973_b((Vector3i)entityPos)));
        });
        if (pos != entityPos) {
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, entity.func_189653_aC().field_189983_j, entity.func_189653_aC().field_189982_i);
            entity.func_70661_as().func_75499_g();
            BrainUtils.clearMemory(entity, MemoryModuleType.field_220950_k);
        }
    }
}

