/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;

public class MoveToWalkTarget<E extends CreatureEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_223021_x, (Object)MemoryModuleStatus.REGISTERED), Pair.of((Object)MemoryModuleType.field_220954_o, (Object)MemoryModuleStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_PRESENT)});
    @Nullable
    protected Path path;
    @Nullable
    protected BlockPos lastTargetPos;
    protected float speedModifier;

    public MoveToWalkTarget() {
        this.runFor(entity -> entity.func_70681_au().nextInt(100) + 150);
        this.cooldownFor(entity -> entity.func_70681_au().nextInt(40));
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerWorld level, E entity) {
        Brain brain = entity.func_213375_cj();
        WalkTarget walkTarget = (WalkTarget)BrainUtils.getMemory(brain, MemoryModuleType.field_220950_k);
        if (!this.hasReachedTarget(entity, walkTarget) && this.attemptNewPath(entity, walkTarget, false)) {
            this.lastTargetPos = walkTarget.func_220966_a().func_220608_a();
            return true;
        }
        BrainUtils.clearMemory(brain, MemoryModuleType.field_220950_k);
        BrainUtils.clearMemory(brain, MemoryModuleType.field_223021_x);
        return false;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        if (this.path == null || this.lastTargetPos == null) {
            return false;
        }
        if (entity.func_70661_as().func_75500_f()) {
            return false;
        }
        WalkTarget walkTarget = (WalkTarget)BrainUtils.getMemory(entity, MemoryModuleType.field_220950_k);
        return walkTarget != null && !this.hasReachedTarget(entity, walkTarget);
    }

    @Override
    protected void start(E entity) {
        this.startOnNewPath(entity);
    }

    @Override
    protected void tick(E entity) {
        WalkTarget walkTarget;
        Path path = entity.func_70661_as().func_75505_d();
        Brain brain = entity.func_213375_cj();
        if (this.path != path) {
            this.path = path;
            BrainUtils.setMemory(brain, MemoryModuleType.field_220954_o, path);
        }
        if (path != null && this.lastTargetPos != null && (walkTarget = (WalkTarget)BrainUtils.getMemory(brain, MemoryModuleType.field_220950_k)).func_220966_a().func_220608_a().func_177951_i((Vector3i)this.lastTargetPos) > 4.0 && this.attemptNewPath(entity, walkTarget, this.hasReachedTarget(entity, walkTarget))) {
            this.lastTargetPos = walkTarget.func_220966_a().func_220608_a();
            this.startOnNewPath(entity);
        }
    }

    @Override
    protected void stop(E entity) {
        Brain brain = entity.func_213375_cj();
        if (!entity.func_70661_as().func_244428_t() || !BrainUtils.hasMemory(brain, MemoryModuleType.field_220950_k) || this.hasReachedTarget(entity, (WalkTarget)BrainUtils.getMemory(brain, MemoryModuleType.field_220950_k))) {
            this.cooldownFinishedAt = 0L;
        }
        entity.func_70661_as().func_75499_g();
        BrainUtils.clearMemories(brain, MemoryModuleType.field_220950_k, MemoryModuleType.field_220954_o);
        this.path = null;
    }

    protected boolean attemptNewPath(E entity, WalkTarget walkTarget, boolean reachedCurrentTarget) {
        Brain brain = entity.func_213375_cj();
        BlockPos pos = walkTarget.func_220966_a().func_220608_a();
        this.path = entity.func_70661_as().func_179680_a(pos, 0);
        this.speedModifier = walkTarget.func_220965_b();
        if (reachedCurrentTarget) {
            BrainUtils.clearMemory(brain, MemoryModuleType.field_223021_x);
            return false;
        }
        if (this.path != null && this.path.func_224771_h()) {
            BrainUtils.clearMemory(brain, MemoryModuleType.field_223021_x);
        } else {
            BrainUtils.setMemory(brain, MemoryModuleType.field_223021_x, Long.valueOf(((CreatureEntity)entity).field_70170_p.func_82737_E()));
        }
        if (this.path != null) {
            return true;
        }
        Vector3d newTargetPos = RandomPositionGenerator.func_203155_a(entity, (int)10, (int)7, (Vector3d)Vector3d.func_237492_c_((Vector3i)pos), (double)1.5707963267948966);
        if (newTargetPos != null) {
            this.path = entity.func_70661_as().func_225466_a(newTargetPos.func_82615_a(), newTargetPos.func_82617_b(), newTargetPos.func_82616_c(), 0);
            return this.path != null;
        }
        return false;
    }

    protected boolean hasReachedTarget(E entity, WalkTarget target) {
        return target.func_220966_a().func_220608_a().func_218139_n((Vector3i)entity.func_233580_cy_()) <= target.func_220964_c();
    }

    protected void startOnNewPath(E entity) {
        BrainUtils.setMemory(entity, MemoryModuleType.field_220954_o, this.path);
        entity.func_70661_as().func_75484_a(this.path, (double)this.speedModifier);
    }
}

