/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.util.math.vector.Vector3d;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;

public class StayWithinDistanceOfAttackTarget<E extends CreatureEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT)});
    protected BiFunction<E, LivingEntity, Float> distMax = (entity, target) -> Float.valueOf(20.0f);
    protected BiFunction<E, LivingEntity, Float> distMin = (entity, target) -> Float.valueOf(5.0f);
    protected Predicate<E> stopWhen = entity -> false;
    protected float speedMod = 1.0f;
    protected float repositionSpeedMod = 1.3f;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Deprecated
    public StayWithinDistanceOfAttackTarget<E> stopStrafingWhen(Predicate<E> predicate) {
        this.stopWhen = predicate;
        return this;
    }

    public StayWithinDistanceOfAttackTarget<E> minDistance(float distance) {
        return this.minDistance((entity, target) -> Float.valueOf(distance));
    }

    public StayWithinDistanceOfAttackTarget<E> minDistance(BiFunction<E, LivingEntity, Float> distance) {
        this.distMin = distance;
        return this;
    }

    public StayWithinDistanceOfAttackTarget<E> maxDistance(float distance) {
        return this.maxDistance((entity, target) -> Float.valueOf(distance));
    }

    public StayWithinDistanceOfAttackTarget<E> maxDistance(BiFunction<E, LivingEntity, Float> distance) {
        this.distMax = distance;
        return this;
    }

    public StayWithinDistanceOfAttackTarget<E> speedMod(float modifier) {
        this.speedMod = modifier;
        return this;
    }

    public StayWithinDistanceOfAttackTarget<E> repositionSpeedMod(float modifier) {
        this.speedMod = modifier;
        return this;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return BrainUtils.hasMemory(entity, MemoryModuleType.field_234103_o_) && !this.stopWhen.test(entity);
    }

    @Override
    protected void tick(E entity) {
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        double distanceToTarget = target.func_70068_e(entity);
        float maxDist = this.distMax.apply(entity, target).floatValue();
        double maxDistSq = Math.pow(maxDist, 2.0);
        double minDistSq = Math.pow(this.distMin.apply(entity, target).floatValue(), 2.0);
        PathNavigator navigation = entity.func_70661_as();
        if (distanceToTarget > maxDistSq || !entity.func_70685_l((Entity)target)) {
            if (navigation.func_75500_f()) {
                navigation.func_75497_a((Entity)target, (double)this.repositionSpeedMod);
            }
            return;
        }
        if (distanceToTarget < minDistSq) {
            Vector3d runPos;
            if (navigation.func_75500_f() && (runPos = RandomPositionGenerator.func_234133_a_(entity, (int)((int)maxDist), (int)5, (Vector3d)target.func_213303_ch())) != null) {
                navigation.func_75484_a(navigation.func_179680_a(new BlockPos(runPos), 1), (double)this.repositionSpeedMod);
            }
            return;
        }
        navigation.func_75499_g();
        BrainUtils.setMemory(entity, MemoryModuleType.field_220951_l, new EntityPosWrapper((Entity)target, true));
        if (distanceToTarget > maxDistSq * 0.5) {
            entity.func_70625_a((Entity)target, 30.0f, 30.0f);
            entity.func_70605_aq().func_188488_a(0.5f * this.speedMod, 0.0f);
        } else if (distanceToTarget < minDistSq * 3.0) {
            entity.func_70625_a((Entity)target, 30.0f, 30.0f);
            entity.func_70605_aq().func_188488_a(-0.5f * this.speedMod, 0.0f);
        }
    }
}

