/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;

public class StrafeTarget<E extends MobEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT)});
    protected boolean strafingLaterally = false;
    protected boolean strafingBack = false;
    protected int strafeCounter = -1;
    protected float strafeDistanceSqr = 244.0f;
    protected Predicate<E> stopStrafingWhen = entity -> false;
    protected float speedMod = 1.0f;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public StrafeTarget<E> stopStrafingWhen(Predicate<E> predicate) {
        this.stopStrafingWhen = predicate;
        return this;
    }

    public StrafeTarget<E> strafeDistance(float distance) {
        this.strafeDistanceSqr = distance * distance;
        return this;
    }

    public StrafeTarget<E> speedMod(float modifier) {
        this.speedMod = modifier;
        return this;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return BrainUtils.hasMemory(entity, MemoryModuleType.field_234103_o_) && !this.stopStrafingWhen.test(entity);
    }

    @Override
    protected void tick(E entity) {
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        double distanceToTarget = target.func_70068_e(entity);
        if (distanceToTarget <= (double)this.strafeDistanceSqr) {
            entity.func_70661_as().func_75499_g();
            ++this.strafeCounter;
        } else {
            entity.func_70661_as().func_75497_a((Entity)target, (double)this.speedMod);
            this.strafeCounter = -1;
        }
        if (this.strafeCounter >= 20) {
            if ((double)entity.func_70681_au().nextFloat() < 0.3) {
                boolean bl = this.strafingLaterally = !this.strafingLaterally;
            }
            if ((double)entity.func_70681_au().nextFloat() < 0.3) {
                this.strafingBack = !this.strafingBack;
            }
            this.strafeCounter = 0;
        }
        if (this.strafeCounter > -1) {
            if (distanceToTarget > (double)(this.strafeDistanceSqr * 0.75f)) {
                this.strafingBack = false;
            } else if (distanceToTarget < (double)(this.strafeDistanceSqr * 0.25f)) {
                this.strafingBack = true;
            }
            entity.func_70625_a((Entity)target, 30.0f, 30.0f);
            entity.func_70605_aq().func_188488_a(this.strafingBack ? -0.5f : 0.5f, this.strafingLaterally ? 0.5f : -0.5f);
        }
    }
}

