/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.path;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.api.util.RandomUtil;
import net.tslat.smartbrainlib.object.SquareRadius;

public class SeekRandomNearbyPosition<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORIES = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT)});
    protected BiPredicate<E, BlockState> validPosition = (entity, state) -> false;
    protected BiFunction<E, Vector3d, Float> speedModifier = (entity, targetPos) -> Float.valueOf(1.0f);
    protected SquareRadius radius = new SquareRadius(10.0, 6.0);
    protected Function<E, Integer> tries = entity -> 10;
    protected Vector3d targetPos = null;

    public SeekRandomNearbyPosition<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public SeekRandomNearbyPosition<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    public SeekRandomNearbyPosition<E> speedModifier(float modifier) {
        return this.speedModifier((entity, targetPos) -> Float.valueOf(modifier));
    }

    public SeekRandomNearbyPosition<E> speedModifier(BiFunction<E, Vector3d, Float> function) {
        this.speedModifier = function;
        return this;
    }

    public SeekRandomNearbyPosition<E> attempts(int attempts) {
        return this.attempts(entity -> attempts);
    }

    public SeekRandomNearbyPosition<E> attempts(Function<E, Integer> function) {
        this.tries = function;
        return this;
    }

    public SeekRandomNearbyPosition<E> validPositions(BiPredicate<E, BlockState> predicate) {
        this.validPosition = predicate;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    @Override
    protected boolean func_212832_a_(ServerWorld level, E entity) {
        this.targetPos = this.getTargetPos(entity);
        return this.targetPos != null;
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setMemory(entity, MemoryModuleType.field_220950_k, new WalkTarget(this.targetPos, this.speedModifier.apply(entity, this.targetPos).floatValue(), 0));
    }

    @Nullable
    protected Vector3d getTargetPos(E entity) {
        BlockPos entityPos = entity.func_233580_cy_();
        BlockPos targetPos = RandomUtil.getRandomPositionWithinRange(entityPos, (int)this.radius.xzRadius(), (int)this.radius.yRadius(), (int)this.radius.xzRadius(), 0, 0, 0, false, ((LivingEntity)entity).field_70170_p, 10, (state, pos) -> this.validPosition.test(entity, (BlockState)state));
        return targetPos == entityPos ? null : Vector3d.func_237492_c_((Vector3i)targetPos);
    }
}

