/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.path;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.util.math.vector.Vector3d;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.object.SquareRadius;

public class SetRandomWalkTarget<E extends CreatureEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT)});
    protected BiFunction<E, Vector3d, Float> speedModifier = (entity, targetPos) -> Float.valueOf(1.0f);
    protected Predicate<E> avoidWaterPredicate = entity -> true;
    protected SquareRadius radius = new SquareRadius(10.0, 7.0);
    protected BiPredicate<E, Vector3d> positionPredicate = (entity, pos) -> true;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public SetRandomWalkTarget<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public SetRandomWalkTarget<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    public SetRandomWalkTarget<E> speedModifier(float modifier) {
        return this.speedModifier((entity, targetPos) -> Float.valueOf(modifier));
    }

    public SetRandomWalkTarget<E> speedModifier(BiFunction<E, Vector3d, Float> function) {
        this.speedModifier = function;
        return this;
    }

    public SetRandomWalkTarget<E> walkTargetPredicate(BiPredicate<E, Vector3d> predicate) {
        this.positionPredicate = predicate;
        return this;
    }

    public SetRandomWalkTarget<E> dontAvoidWater() {
        return this.avoidWaterWhen(entity -> false);
    }

    public SetRandomWalkTarget<E> avoidWaterWhen(Predicate<E> predicate) {
        this.avoidWaterPredicate = predicate;
        return this;
    }

    @Override
    protected void start(E entity) {
        Vector3d targetPos = this.getTargetPos(entity);
        if (!this.positionPredicate.test(entity, targetPos)) {
            targetPos = null;
        }
        if (targetPos == null) {
            BrainUtils.clearMemory(entity, MemoryModuleType.field_220950_k);
        } else {
            BrainUtils.setMemory(entity, MemoryModuleType.field_220950_k, new WalkTarget(targetPos, this.speedModifier.apply(entity, targetPos).floatValue(), 0));
        }
    }

    @Nullable
    protected Vector3d getTargetPos(E entity) {
        if (this.avoidWaterPredicate.test(entity)) {
            return RandomPositionGenerator.func_191377_b(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()));
        }
        return RandomPositionGenerator.func_191377_b(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()));
    }
}

