/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;

public class SetAttackTarget<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_ABSENT), Pair.of((Object)SBLMemoryTypes.NEAREST_ATTACKABLE.get(), (Object)MemoryModuleStatus.VALUE_PRESENT)});
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> CUSTOM_TARGETING_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_ABSENT)});
    protected final boolean usingNearestAttackable;
    protected Predicate<E> canAttackPredicate = entity -> true;
    protected Function<E, ? extends LivingEntity> targetFinder = entity -> (LivingEntity)BrainUtils.getMemory(entity, (MemoryModuleType)SBLMemoryTypes.NEAREST_ATTACKABLE.get());

    public SetAttackTarget() {
        this(true);
    }

    public SetAttackTarget(boolean usingNearestAttackable) {
        this.usingNearestAttackable = usingNearestAttackable;
    }

    public SetAttackTarget<E> attackPredicate(Predicate<E> predicate) {
        this.canAttackPredicate = predicate;
        return this;
    }

    public SetAttackTarget<E> targetFinder(Function<E, ? extends LivingEntity> targetFindingFunction) {
        this.targetFinder = targetFindingFunction;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return this.usingNearestAttackable ? MEMORY_REQUIREMENTS : CUSTOM_TARGETING_REQUIREMENTS;
    }

    @Override
    protected boolean func_212832_a_(ServerWorld level, E entity) {
        return this.canAttackPredicate.test(entity);
    }

    @Override
    protected void start(E entity) {
        LivingEntity target = this.targetFinder.apply(entity);
        if (target == null) {
            BrainUtils.clearMemory(entity, MemoryModuleType.field_234103_o_);
        } else {
            BrainUtils.setMemory(entity, MemoryModuleType.field_234103_o_, target);
            BrainUtils.clearMemory(entity, MemoryModuleType.field_223021_x);
        }
    }
}

