/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.object.FreePositionTracker;

public class SetRandomLookTarget<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORIES = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.VALUE_ABSENT)});
    protected Function<Random, Float> runChance = rand -> Float.valueOf(0.02f);
    protected Function<E, Integer> lookTime = entity -> entity.func_70681_au().nextInt(20) + 20;

    public SetRandomLookTarget<E> lookChance(Function<Random, Float> chance) {
        this.runChance = chance;
        return this;
    }

    public SetRandomLookTarget<E> lookTime(Function<E, Integer> function) {
        this.lookTime = function;
        return this;
    }

    @Override
    protected boolean func_212832_a_(ServerWorld level, E entity) {
        return entity.func_70681_au().nextFloat() < this.runChance.apply(entity.func_70681_au()).floatValue();
    }

    @Override
    protected void start(E entity) {
        double angle = Math.PI * 2 * entity.func_70681_au().nextDouble();
        BrainUtils.setForgettableMemory(entity, MemoryModuleType.field_220951_l, new FreePositionTracker(entity.func_174824_e(1.0f).func_72441_c(Math.cos(angle), 0.0, Math.sin(angle))), (int)this.lookTime.apply(entity));
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORIES;
    }
}

