/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.object.NearestVisibleLivingEntities;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;

public class TargetOrRetaliate<E extends MobEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.wrap((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.field_220957_r, (Object)MemoryModuleStatus.REGISTERED), Pair.of((Object)SBLMemoryTypes.NEAREST_ATTACKABLE.get(), (Object)MemoryModuleStatus.REGISTERED), Pair.of((Object)SBLMemoryTypes.NEAREST_VISIBLE_LIVING_ENTITIES.get(), (Object)MemoryModuleStatus.REGISTERED)});
    protected Predicate<LivingEntity> canAttackPredicate = entity -> entity.func_70089_S() && (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).func_184812_l_());
    protected LivingEntity toTarget = null;
    protected MemoryModuleType<? extends LivingEntity> priorityTargetMemory = (MemoryModuleType)SBLMemoryTypes.NEAREST_ATTACKABLE.get();

    public TargetOrRetaliate<E> attackablePredicate(Predicate<LivingEntity> predicate) {
        this.canAttackPredicate = predicate;
        return this;
    }

    public TargetOrRetaliate<E> useMemory(MemoryModuleType<? extends LivingEntity> memory) {
        this.priorityTargetMemory = memory;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryModuleStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerWorld pLevel, E owner) {
        Brain brain = owner.func_213375_cj();
        this.toTarget = BrainUtils.getMemory(brain, this.priorityTargetMemory);
        if (this.toTarget == null) {
            this.toTarget = (LivingEntity)BrainUtils.getMemory(brain, MemoryModuleType.field_220958_s);
        }
        if (this.toTarget == null) {
            NearestVisibleLivingEntities nearbyEntities = (NearestVisibleLivingEntities)BrainUtils.getMemory(brain, (MemoryModuleType)SBLMemoryTypes.NEAREST_VISIBLE_LIVING_ENTITIES.get());
            if (nearbyEntities != null) {
                this.toTarget = nearbyEntities.findFirstMatchingEntry(this.canAttackPredicate).orElse(null);
            }
            if (this.toTarget != null) {
                return true;
            }
        }
        return this.toTarget != null && this.canAttackPredicate.test(this.toTarget);
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setTargetOfEntity(entity, this.toTarget);
        BrainUtils.clearMemory(entity, MemoryModuleType.field_223021_x);
        this.toTarget = null;
    }
}

