/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.object.NearestVisibleLivingEntities;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;

public abstract class EntityFilteringSensor<P, E extends LivingEntity>
extends PredicateSensor<LivingEntity, E> {
    protected abstract MemoryModuleType<P> getMemory();

    @Override
    protected abstract BiPredicate<LivingEntity, E> predicate();

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return Lists.newArrayList((Object[])new MemoryModuleType[]{this.getMemory()});
    }

    @Override
    protected void func_212872_a_(ServerWorld level, E entity) {
        BrainUtils.setMemory(entity, this.getMemory(), this.testForEntity(entity));
    }

    protected P testForEntity(E entity) {
        NearestVisibleLivingEntities matcher = (NearestVisibleLivingEntities)BrainUtils.getMemory(entity, (MemoryModuleType)SBLMemoryTypes.NEAREST_VISIBLE_LIVING_ENTITIES.get());
        if (matcher == null) {
            return null;
        }
        return this.findMatches(entity, matcher);
    }

    @Nullable
    protected abstract P findMatches(E var1, NearestVisibleLivingEntities var2);
}

