/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.custom;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.api.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class IncomingProjectilesSensor<E extends LivingEntity>
extends PredicateSensor<ProjectileEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{(MemoryModuleType)SBLMemoryTypes.INCOMING_PROJECTILES.get()});

    public IncomingProjectilesSensor() {
        this.setScanRate((T entity) -> 3);
        this.setPredicate((projectile, entity) -> {
            if (projectile.func_233570_aj_() || projectile.field_70123_F || projectile.field_70124_G) {
                return false;
            }
            return entity.func_174813_aQ().func_216365_b(projectile.func_213303_ch(), projectile.func_213303_ch().func_178787_e(projectile.func_213322_ci().func_216372_d(3.0, 3.0, 3.0))).isPresent();
        });
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.INCOMING_PROJECTILES.get();
    }

    @Override
    protected void func_212872_a_(ServerWorld level, E entity) {
        List projectiles = EntityRetrievalUtil.getEntities((World)level, entity.func_174813_aQ().func_186662_g(7.0), target -> target instanceof ProjectileEntity && this.predicate().test((ProjectileEntity)target, entity));
        if (!projectiles.isEmpty()) {
            projectiles.sort(Comparator.comparingDouble(arg_0 -> entity.func_70068_e(arg_0)));
            BrainUtils.setMemory(entity, (MemoryModuleType)SBLMemoryTypes.INCOMING_PROJECTILES.get(), projectiles);
        } else {
            BrainUtils.clearMemory(entity, (MemoryModuleType)SBLMemoryTypes.INCOMING_PROJECTILES.get());
        }
    }
}

