/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.custom;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class NearbyBlocksSensor<E extends LivingEntity>
extends PredicateSensor<BlockState, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{(MemoryModuleType)SBLMemoryTypes.NEARBY_BLOCKS.get()});
    protected SquareRadius radius = new SquareRadius(1.0, 1.0);

    public NearbyBlocksSensor() {
        this.setPredicate((state, entity) -> !state.func_196958_f());
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.NEARBY_BLOCKS.get();
    }

    public NearbyBlocksSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyBlocksSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    protected void func_212872_a_(ServerWorld level, E entity) {
        ObjectArrayList blocks = new ObjectArrayList();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)entity.func_233580_cy_().func_177973_b(this.radius.toVec3i()), (BlockPos)entity.func_233580_cy_().func_177971_a(this.radius.toVec3i()))) {
            BlockState state = level.func_180495_p(pos);
            if (!this.predicate().test(state, entity)) continue;
            blocks.add(Pair.of((Object)pos.func_185334_h(), (Object)state));
        }
        if (blocks.isEmpty()) {
            BrainUtils.clearMemory(entity, (MemoryModuleType)SBLMemoryTypes.NEARBY_BLOCKS.get());
        } else {
            BrainUtils.setMemory(entity, (MemoryModuleType)SBLMemoryTypes.NEARBY_BLOCKS.get(), blocks);
        }
    }
}

