/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.custom;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class UnreachableTargetSensor<E extends LivingEntity>
extends ExtendedSensor<E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{MemoryModuleType.field_223021_x, MemoryModuleType.field_234103_o_, (MemoryModuleType)SBLMemoryTypes.TARGET_UNREACHABLE.get()});
    private long lastUnpathableTime = 0L;

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.UNREACHABLE_TARGET.get();
    }

    @Override
    protected void func_212872_a_(ServerWorld level, E entity) {
        Brain brain = entity.func_213375_cj();
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        if (target == null) {
            this.resetState(brain);
            return;
        }
        Long unpathableTime = (Long)BrainUtils.getMemory(brain, MemoryModuleType.field_223021_x);
        if (unpathableTime == null) {
            this.resetState(brain);
            return;
        }
        if (this.lastUnpathableTime == 0L) {
            this.lastUnpathableTime = unpathableTime;
        } else if (this.lastUnpathableTime == unpathableTime) {
            BrainUtils.clearMemory(brain, (MemoryModuleType)SBLMemoryTypes.TARGET_UNREACHABLE.get());
        } else if (this.lastUnpathableTime < unpathableTime) {
            this.lastUnpathableTime = unpathableTime;
            BrainUtils.setMemory(brain, (MemoryModuleType)SBLMemoryTypes.TARGET_UNREACHABLE.get(), Boolean.valueOf(target.func_226278_cu_() > entity.func_226280_cw_()));
        }
    }

    private void resetState(Brain<?> brain) {
        if (this.lastUnpathableTime > 0L) {
            BrainUtils.clearMemory(brain, (MemoryModuleType)SBLMemoryTypes.TARGET_UNREACHABLE.get());
        }
        this.lastUnpathableTime = 0L;
    }
}

