/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class HoglinSpecificSensor<E extends LivingEntity>
extends ExtendedSensor<E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{MemoryModuleType.field_234092_Z_, MemoryModuleType.field_234091_Y_, MemoryModuleType.field_234094_ab_, MemoryModuleType.field_234095_ac_, MemoryModuleType.field_234098_af_});

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.HOGLIN_SPECIFIC.get();
    }

    @Override
    protected void func_212872_a_(ServerWorld level, E entity) {
        Brain brain = entity.func_213375_cj();
        BrainUtils.withMemory(brain, (MemoryModuleType)SBLMemoryTypes.NEAREST_VISIBLE_LIVING_ENTITIES.get(), entities -> {
            int piglinCount = 0;
            PiglinEntity nearestPiglin = null;
            ObjectArrayList hoglins = new ObjectArrayList();
            for (LivingEntity target : entities.findAllMatchingEntries(mob -> !mob.func_70631_g_())) {
                if (target instanceof PiglinEntity) {
                    ++piglinCount;
                    if (nearestPiglin != null) continue;
                    nearestPiglin = (PiglinEntity)target;
                    continue;
                }
                if (!(target instanceof HoglinEntity)) continue;
                hoglins.add((HoglinEntity)target);
            }
            BrainUtils.setMemory(brain, MemoryModuleType.field_234092_Z_, nearestPiglin);
            BrainUtils.setMemory(brain, MemoryModuleType.field_234091_Y_, hoglins);
            BrainUtils.setMemory(brain, MemoryModuleType.field_234094_ab_, Integer.valueOf(piglinCount));
            BrainUtils.setMemory(brain, MemoryModuleType.field_234095_ac_, Integer.valueOf(hoglins.size()));
            BrainUtils.setMemory(brain, MemoryModuleType.field_234098_af_, BlockPos.func_239584_a_((BlockPos)entity.func_233580_cy_(), (int)8, (int)4, pos -> level.func_180495_p(pos).func_235714_a_((ITag)BlockTags.field_232879_au_)).orElse(null));
        });
    }
}

