/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.util.DamageSource;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class HurtBySensor<E extends MobEntity>
extends PredicateSensor<DamageSource, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s});

    public HurtBySensor() {
        super((damageSource, entity) -> true);
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.HURT_BY.get();
    }

    protected void doTick(ServerWorld level, E entity) {
        Brain brain = entity.func_213375_cj();
        DamageSource damageSource = entity.func_189748_bU();
        if (damageSource == null) {
            BrainUtils.clearMemory(brain, MemoryModuleType.field_220957_r);
        } else if (this.predicate().test(damageSource, entity)) {
            BrainUtils.setMemory(brain, MemoryModuleType.field_220957_r, damageSource);
            if (damageSource.func_76346_g() instanceof LivingEntity && ((LivingEntity)damageSource.func_76346_g()).func_70089_S() && ((LivingEntity)damageSource.func_76346_g()).field_70170_p == ((MobEntity)entity).field_70170_p) {
                BrainUtils.setMemory(brain, MemoryModuleType.field_220958_s, (LivingEntity)damageSource.func_76346_g());
            }
        } else {
            BrainUtils.withMemory(brain, MemoryModuleType.field_220958_s, attacker -> {
                if (!attacker.func_70089_S() || attacker.field_70170_p != entity.field_70170_p) {
                    BrainUtils.clearMemory(brain, MemoryModuleType.field_220958_s);
                }
            });
        }
    }
}

