/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.api.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class ItemTemptingSensor<E extends LivingEntity>
extends PredicateSensor<PlayerEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{(MemoryModuleType)SBLMemoryTypes.TEMPTING_PLAYER.get()});
    protected Ingredient temptingItems = Ingredient.field_193370_a;
    protected SquareRadius radius = new SquareRadius(10.0, 10.0);

    public ItemTemptingSensor() {
        this.setPredicate((target, entity) -> {
            if (target.func_175149_v() || !target.func_70089_S()) {
                return false;
            }
            return this.temptingItems.test(target.func_184614_ca()) || this.temptingItems.test(target.func_184592_cb());
        });
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.ITEM_TEMPTING.get();
    }

    public ItemTemptingSensor<E> setTemptingItems(Ingredient temptingItems) {
        this.temptingItems = temptingItems;
        return this;
    }

    public ItemTemptingSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public ItemTemptingSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    protected void func_212872_a_(ServerWorld level, E entity) {
        BrainUtils.setMemory(entity, (MemoryModuleType)SBLMemoryTypes.TEMPTING_PLAYER.get(), EntityRetrievalUtil.getNearestPlayer(entity, this.radius.xzRadius(), this.radius.yRadius(), this.radius.xzRadius(), target -> this.predicate().test(target, entity)));
    }
}

