/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class NearbyGolemSensor<E extends LivingEntity>
extends PredicateSensor<LivingEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{MemoryModuleType.field_242309_E});
    private int timeToRemember = 600;

    public NearbyGolemSensor() {
        this.setScanRate((T entity) -> 200);
        this.setPredicate((target, entity) -> target.func_200600_R() == EntityType.field_200757_aw && target.func_70089_S());
    }

    public NearbyGolemSensor<E> setMemoryTime(int ticks) {
        this.timeToRemember = ticks;
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.NEARBY_GOLEM.get();
    }

    @Override
    protected void func_212872_a_(ServerWorld level, E entity) {
        BrainUtils.withMemory(entity, MemoryModuleType.field_220945_f, entityList -> {
            if (entityList.isEmpty()) {
                return;
            }
            for (LivingEntity target : entityList) {
                if (!this.predicate().test(target, entity)) continue;
                BrainUtils.setForgettableMemory(entity, MemoryModuleType.field_242309_E, Boolean.valueOf(true), this.timeToRemember);
                return;
            }
        });
    }
}

