/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.tslat.smartbrainlib.api.core.sensor.EntityFilteringSensor;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.object.NearestVisibleLivingEntities;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class NearbyHostileSensor<E extends LivingEntity>
extends EntityFilteringSensor<LivingEntity, E> {
    private final Map<EntityType<?>, Float> hostileDistanceMap = new Object2FloatOpenHashMap(11);

    public NearbyHostileSensor() {
        this.setHostiles(Pair.of((Object)EntityType.field_204724_o, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.field_200763_C, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.field_200755_au, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.field_200725_aD, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.field_200727_aF, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.field_200758_ax, (Object)Float.valueOf(10.0f)), Pair.of((Object)EntityType.field_233590_aW_, (Object)Float.valueOf(10.0f)), Pair.of((Object)EntityType.field_200806_t, (Object)Float.valueOf(12.0f)), Pair.of((Object)EntityType.field_200764_D, (Object)Float.valueOf(12.0f)), Pair.of((Object)EntityType.field_220352_aU, (Object)Float.valueOf(12.0f)), Pair.of((Object)EntityType.field_220350_aJ, (Object)Float.valueOf(15.0f)));
    }

    public NearbyHostileSensor<E> setHostiles(Pair<EntityType<?>, Float> ... entries) {
        this.hostileDistanceMap.clear();
        for (Pair<EntityType<?>, Float> entry : entries) {
            this.hostileDistanceMap.put((EntityType<?>)entry.getFirst(), (Float)entry.getSecond());
        }
        return this;
    }

    public NearbyHostileSensor<E> addHostile(Pair<EntityType<?>, Float> entry) {
        this.hostileDistanceMap.put((EntityType<?>)entry.getFirst(), (Float)entry.getSecond());
        return this;
    }

    @Override
    public MemoryModuleType<LivingEntity> getMemory() {
        return MemoryModuleType.field_220959_t;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.NEARBY_HOSTILE.get();
    }

    @Override
    protected BiPredicate<LivingEntity, E> predicate() {
        return (target, entity) -> {
            Float distance = this.hostileDistanceMap.get(target.func_200600_R());
            return distance != null && target.func_70068_e((Entity)entity) <= (double)(distance.floatValue() * distance.floatValue());
        };
    }

    @Override
    @Nullable
    protected LivingEntity findMatches(E entity, NearestVisibleLivingEntities matcher) {
        return matcher.findFirstMatchingEntry(target -> this.predicate().test((LivingEntity)target, entity)).orElse(null);
    }
}

