/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.api.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.object.NearestVisibleLivingEntities;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class NearbyLivingEntitySensor<E extends LivingEntity>
extends PredicateSensor<LivingEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{MemoryModuleType.field_220945_f, (MemoryModuleType)SBLMemoryTypes.NEAREST_VISIBLE_LIVING_ENTITIES.get()});
    @Nullable
    protected SquareRadius radius = null;

    public NearbyLivingEntitySensor() {
        super((target, entity) -> target != entity && target.func_70089_S());
    }

    public NearbyLivingEntitySensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyLivingEntitySensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.NEARBY_LIVING_ENTITY.get();
    }

    @Override
    protected void func_212872_a_(ServerWorld level, E entity) {
        SquareRadius radius = this.radius;
        if (radius == null) {
            double dist = entity.func_233637_b_(Attributes.field_233819_b_);
            radius = new SquareRadius(dist, dist);
        }
        List<LivingEntity> entities = EntityRetrievalUtil.getEntities((World)level, entity.func_174813_aQ().func_72314_b(radius.xzRadius(), radius.yRadius(), radius.xzRadius()), obj -> obj instanceof LivingEntity && this.predicate().test((LivingEntity)obj, entity));
        entities.sort(Comparator.comparingDouble(arg_0 -> entity.func_70068_e(arg_0)));
        BrainUtils.setMemory(entity, MemoryModuleType.field_220945_f, entities);
        BrainUtils.setMemory(entity, (MemoryModuleType)SBLMemoryTypes.NEAREST_VISIBLE_LIVING_ENTITIES.get(), new NearestVisibleLivingEntities((LivingEntity)entity, entities));
    }
}

