/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.api.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class NearbyPlayersSensor<E extends LivingEntity>
extends PredicateSensor<PlayerEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{MemoryModuleType.field_220948_i, MemoryModuleType.field_220949_j, MemoryModuleType.field_234102_l_});
    @Nullable
    protected SquareRadius radius = null;

    public NearbyPlayersSensor() {
        super((player, entity) -> !player.func_175149_v());
    }

    public NearbyPlayersSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyPlayersSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.NEARBY_PLAYERS.get();
    }

    @Override
    protected void func_212872_a_(ServerWorld level, E entity) {
        SquareRadius radius = this.radius;
        if (radius == null) {
            double dist = entity.func_233637_b_(Attributes.field_233819_b_);
            radius = new SquareRadius(dist, dist);
        }
        List<PlayerEntity> players = EntityRetrievalUtil.getPlayers((World)level, radius.inflateAABB(entity.func_174813_aQ()), player -> this.predicate().test(player, entity));
        players.sort(Comparator.comparingDouble(arg_0 -> entity.func_70068_e(arg_0)));
        ObjectArrayList targetablePlayers = new ObjectArrayList(players);
        targetablePlayers.removeIf(pl -> !NearbyPlayersSensor.func_242316_a((LivingEntity)entity, (LivingEntity)pl));
        ObjectArrayList attackablePlayers = new ObjectArrayList((Collection)targetablePlayers);
        attackablePlayers.removeIf(pl -> !NearbyPlayersSensor.func_242316_a((LivingEntity)entity, (LivingEntity)pl));
        BrainUtils.setMemory(entity, MemoryModuleType.field_220948_i, players);
        BrainUtils.setMemory(entity, MemoryModuleType.field_220949_j, targetablePlayers.isEmpty() ? null : (PlayerEntity)targetablePlayers.get(0));
        BrainUtils.setMemory(entity, MemoryModuleType.field_234102_l_, attackablePlayers.isEmpty() ? null : (PlayerEntity)attackablePlayers.get(0));
    }
}

