/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class NearestHomeSensor<E extends MobEntity>
extends PredicateSensor<E, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{MemoryModuleType.field_220956_q});
    protected int radius = 48;
    private final Object2LongOpenHashMap<BlockPos> homesMap = new Object2LongOpenHashMap(5);
    private int tries = 0;

    public NearestHomeSensor() {
        super((brainOwner, entity) -> brainOwner.func_70631_g_());
    }

    public NearestHomeSensor<E> setRadius(int radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.NEAREST_HOME.get();
    }

    protected void doTick(ServerWorld level, E entity) {
        if (!this.predicate().test(entity, entity)) {
            return;
        }
        this.tries = 0;
        long nodeExpiryTime = level.func_82737_E() + (long)level.func_201674_k().nextInt(20);
        PointOfInterestManager poiManager = level.func_217443_B();
        Predicate<BlockPos> predicate = pos -> {
            if (this.homesMap.containsKey(pos)) {
                return false;
            }
            if (++this.tries >= 5) {
                return false;
            }
            this.homesMap.put(pos, nodeExpiryTime + 40L);
            return true;
        };
        Set poiLocations = poiManager.func_225399_a(poiType -> poiType.equals(PointOfInterestType.field_221069_q), predicate, entity.func_233580_cy_(), this.radius, PointOfInterestManager.Status.ANY).collect(Collectors.toSet());
        Path pathToHome = entity.func_70661_as().func_241390_a_(poiLocations, PointOfInterestType.field_221069_q.func_225478_d());
        if (pathToHome != null && pathToHome.func_224771_h()) {
            BlockPos targetPos = pathToHome.func_224770_k();
            poiManager.func_219148_c(targetPos).ifPresent(poiType -> BrainUtils.setMemory((LivingEntity)entity, MemoryModuleType.field_220956_q, targetPos));
        } else if (this.tries < 5) {
            this.homesMap.object2LongEntrySet().removeIf(pos -> pos.getLongValue() < nodeExpiryTime);
        }
    }
}

