/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.api.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class NearestItemSensor<E extends MobEntity>
extends PredicateSensor<ItemEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{MemoryModuleType.field_234076_J_});
    protected SquareRadius radius = new SquareRadius(32.0, 16.0);

    public NearestItemSensor() {
        super((item, entity) -> entity.func_230293_i_(item.func_92059_d()) && entity.func_70685_l((Entity)item));
    }

    public NearestItemSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearestItemSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.NEAREST_ITEM.get();
    }

    protected void doTick(ServerWorld level, E entity) {
        BrainUtils.setMemory(entity, MemoryModuleType.field_234076_J_, EntityRetrievalUtil.getNearestEntity((World)level, this.radius.inflateAABB(entity.func_174813_aQ()), entity.func_213303_ch(), obj -> obj instanceof ItemEntity && this.predicate().test((ItemEntity)obj, entity)));
    }
}

