/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class PiglinSpecificSensor<E extends LivingEntity>
extends ExtendedSensor<E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{MemoryModuleType.field_234077_K_, MemoryModuleType.field_234085_S_, MemoryModuleType.field_234086_T_, MemoryModuleType.field_234093_aa_, MemoryModuleType.field_234088_V_, MemoryModuleType.field_234096_ad_, MemoryModuleType.field_234090_X_, MemoryModuleType.field_234094_ab_, MemoryModuleType.field_234095_ac_, MemoryModuleType.field_234098_af_, MemoryModuleType.field_220945_f, MemoryModuleType.field_234089_W_});

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.PIGLIN_SPECIFIC.get();
    }

    @Override
    protected void func_212872_a_(ServerWorld level, E entity) {
        Brain brain = entity.func_213375_cj();
        ObjectArrayList adultPiglins = new ObjectArrayList();
        BrainUtils.withMemory(brain, (MemoryModuleType)SBLMemoryTypes.NEAREST_VISIBLE_LIVING_ENTITIES.get(), entities -> {
            MobEntity nemesis = null;
            HoglinEntity nearestHuntableHoglin = null;
            HoglinEntity nearestBabyHoglin = null;
            LivingEntity nearestZombified = null;
            PlayerEntity nearestPlayerWithoutGold = null;
            PlayerEntity nearestPlayerWithWantedItem = null;
            ObjectArrayList visibleAdultPiglins = new ObjectArrayList();
            int adultHoglinCount = 0;
            for (LivingEntity target : entities.findAllMatchingEntries(obj -> true)) {
                if (target instanceof HoglinEntity) {
                    HoglinEntity hoglin = (HoglinEntity)target;
                    if (hoglin.func_70631_g_() && nearestBabyHoglin == null) {
                        nearestBabyHoglin = hoglin;
                        continue;
                    }
                    if (!hoglin.func_234363_eJ_()) continue;
                    ++adultHoglinCount;
                    if (nearestHuntableHoglin != null || !hoglin.func_234365_eM_()) continue;
                    nearestHuntableHoglin = hoglin;
                    continue;
                }
                if (target instanceof PiglinBruteEntity) {
                    visibleAdultPiglins.add((PiglinBruteEntity)target);
                    continue;
                }
                if (target instanceof PiglinEntity) {
                    if (!((PiglinEntity)target).func_242337_eM()) continue;
                    visibleAdultPiglins.add((PiglinEntity)target);
                    continue;
                }
                if (target instanceof PlayerEntity) {
                    if (nearestPlayerWithoutGold == null && !PiglinTasks.func_234460_a_((LivingEntity)target) && entity.func_213336_c(target)) {
                        nearestPlayerWithoutGold = (PlayerEntity)target;
                    }
                    if (nearestPlayerWithWantedItem != null || target.func_175149_v() || !PiglinTasks.func_234482_b_((LivingEntity)target)) continue;
                    nearestPlayerWithWantedItem = (PlayerEntity)target;
                    continue;
                }
                if (nemesis != null || !(target instanceof WitherSkeletonEntity) && !(target instanceof WitherEntity)) {
                    if (nearestZombified != null || !PiglinTasks.func_234459_a_((EntityType)target.func_200600_R())) continue;
                    nearestZombified = target;
                    continue;
                }
                nemesis = (MobEntity)target;
            }
            BrainUtils.setMemory(brain, MemoryModuleType.field_234077_K_, nemesis);
            BrainUtils.setMemory(brain, MemoryModuleType.field_234085_S_, nearestHuntableHoglin);
            BrainUtils.setMemory(brain, MemoryModuleType.field_234086_T_, nearestBabyHoglin);
            BrainUtils.setMemory(brain, MemoryModuleType.field_234093_aa_, nearestZombified);
            BrainUtils.setMemory(brain, MemoryModuleType.field_234088_V_, nearestPlayerWithoutGold);
            BrainUtils.setMemory(brain, MemoryModuleType.field_234096_ad_, nearestPlayerWithWantedItem);
            BrainUtils.setMemory(brain, MemoryModuleType.field_234090_X_, visibleAdultPiglins);
            BrainUtils.setMemory(brain, MemoryModuleType.field_234094_ab_, Integer.valueOf(visibleAdultPiglins.size()));
            BrainUtils.setMemory(brain, MemoryModuleType.field_234095_ac_, Integer.valueOf(adultHoglinCount));
            BrainUtils.setMemory(brain, MemoryModuleType.field_234098_af_, BlockPos.func_239584_a_((BlockPos)entity.func_233580_cy_(), (int)8, (int)4, pos -> {
                BlockState state = level.func_180495_p(pos);
                boolean isRepellent = state.func_235714_a_((ITag)BlockTags.field_232865_O_);
                return isRepellent && state.func_203425_a(Blocks.field_235367_mf_) ? CampfireBlock.func_226915_i_((BlockState)state) : isRepellent;
            }).orElse(null));
        });
        BrainUtils.withMemory(brain, MemoryModuleType.field_220945_f, arg_0 -> PiglinSpecificSensor.lambda$doTick$3((List)adultPiglins, arg_0));
        BrainUtils.setMemory(brain, MemoryModuleType.field_234089_W_, adultPiglins);
    }

    private static /* synthetic */ void lambda$doTick$3(List adultPiglins, List entities) {
        for (LivingEntity target : entities) {
            if (!(target instanceof AbstractPiglinEntity) || !((AbstractPiglinEntity)target).func_242337_eM()) continue;
            adultPiglins.add((AbstractPiglinEntity)target);
        }
    }
}

