/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.server.ServerWorld;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.registry.SBLSensors;

public class SecondaryPoiSensor<E extends VillagerEntity>
extends ExtendedSensor<E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.wrap((Object[])new MemoryModuleType[]{MemoryModuleType.field_220944_e});
    protected SquareRadius radius = new SquareRadius(8.0, 4.0);

    public SecondaryPoiSensor() {
        this.setScanRate(entity -> 40);
    }

    public SecondaryPoiSensor<E> setRadius(int radius) {
        return this.setRadius(radius, radius);
    }

    public SecondaryPoiSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.SECONDARY_POI.get();
    }

    protected void doTick(ServerWorld level, E entity) {
        RegistryKey dimension = level.func_234923_W_();
        BlockPos pos = entity.func_233580_cy_();
        ImmutableSet testPoiBlocks = entity.func_213700_eh().func_221130_b().func_221150_d();
        ObjectArrayList poiPositions = new ObjectArrayList();
        if (testPoiBlocks.isEmpty()) {
            return;
        }
        for (BlockPos testPos : BlockPos.func_191531_b((int)(pos.func_177958_n() - (int)this.radius.xzRadius() / 2), (int)(pos.func_177956_o() - (int)this.radius.yRadius() / 2), (int)(pos.func_177952_p() - (int)this.radius.xzRadius() / 2), (int)(pos.func_177958_n() + (int)this.radius.xzRadius() / 2), (int)(pos.func_177956_o() + (int)this.radius.yRadius() / 2), (int)(pos.func_177952_p() + (int)this.radius.xzRadius() / 2))) {
            if (!testPoiBlocks.contains((Object)level.func_180495_p(testPos).func_177230_c())) continue;
            poiPositions.add(GlobalPos.func_239648_a_((RegistryKey)dimension, (BlockPos)testPos.func_185334_h()));
        }
        if (poiPositions.isEmpty()) {
            BrainUtils.clearMemory(entity, MemoryModuleType.field_220944_e);
        } else {
            BrainUtils.setMemory(entity, MemoryModuleType.field_220944_e, poiPositions);
        }
    }
}

